/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.kuba6000.mobsinfo.MobsInfo;
import com.kuba6000.mobsinfo.api.VillagerRecipe;
import com.kuba6000.mobsinfo.api.VillagerTrade;
import com.kuba6000.mobsinfo.api.helper.TranslationHelper;
import com.kuba6000.mobsinfo.api.utils.FastRandom;
import com.kuba6000.mobsinfo.api.utils.MobUtils;
import com.kuba6000.mobsinfo.config.Config;
import com.kuba6000.mobsinfo.nei.NEI_Config;
import com.kuba6000.mobsinfo.nei.scrollable.IScrollableGUI;
import com.kuba6000.mobsinfo.nei.scrollable.Scrollbar;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.glu.GLU;

public class VillagerTradesHandler
extends TemplateRecipeHandler
implements IScrollableGUI {
    private static final String[] vanillaVillagers = new String[]{"farmer", "librarian", "priest", "blacksmith", "butcher"};
    private static final List<VillagerCachedRecipe> cachedRecipes = new ArrayList<VillagerCachedRecipe>();
    private static final Logger LOG = LogManager.getLogger((String)"mobsinfo[Villager Trades Handler]");
    private static final VillagerTradesHandler instance = new VillagerTradesHandler();
    public static int cycleTicksStatic = Math.abs((int)System.currentTimeMillis());
    private final Scrollbar scrollbar;
    private static final FloatBuffer matrixBuffer = BufferUtils.createFloatBuffer((int)16);
    private HashMap<java.awt.Rectangle, VillagerTrade> recipeRects = new HashMap();

    public static void addRecipe(VillagerRecipe recipe) {
        if (recipe != null) {
            VillagerTradesHandler.addRecipe(recipe.trades, recipe.mob);
        }
    }

    public static void addRecipe(List<VillagerTrade> recipeList, EntityVillager displayMob) {
        ArrayList<Pair<Pair<Pair<VillagerCachedRecipe.PositionedTradeItem, VillagerCachedRecipe.PositionedTradeItem>, VillagerCachedRecipe.PositionedTradeItem>, VillagerTrade>> tradeList = new ArrayList<Pair<Pair<Pair<VillagerCachedRecipe.PositionedTradeItem, VillagerCachedRecipe.PositionedTradeItem>, VillagerCachedRecipe.PositionedTradeItem>, VillagerTrade>>(recipeList.size());
        int x = 7;
        int y = 95;
        boolean second = false;
        for (VillagerTrade recipe : recipeList) {
            tradeList.add((Pair<Pair<Pair<VillagerCachedRecipe.PositionedTradeItem, VillagerCachedRecipe.PositionedTradeItem>, VillagerCachedRecipe.PositionedTradeItem>, VillagerTrade>)Pair.of((Object)Pair.of((Object)Pair.of((Object)((Object)new VillagerCachedRecipe.PositionedTradeItem(recipe.getFirstInput(), x, y)), (Object)((Object)(recipe.hasSecondInput() ? new VillagerCachedRecipe.PositionedTradeItem(recipe.getSecondInput(), x + 18, y) : null))), (Object)((Object)new VillagerCachedRecipe.PositionedTradeItem(recipe.getOutput(), x + 59, y))), (Object)recipe));
            if (!second) {
                x += 79;
                second = true;
                continue;
            }
            x = 7;
            y += 20;
            second = false;
        }
        instance.addRecipeInt(tradeList, displayMob);
    }

    public static void clearRecipes() {
        cachedRecipes.clear();
    }

    public static void sortCachedRecipes() {
        cachedRecipes.sort((o1, o2) -> {
            boolean m1 = ((VillagerCachedRecipe)o1).mod.equals("Minecraft");
            boolean m2 = ((VillagerCachedRecipe)o2).mod.equals("Minecraft");
            if (m1 && !m2) {
                return -1;
            }
            if (!m1 && m2) {
                return 1;
            }
            if (!((VillagerCachedRecipe)o1).mod.equals(((VillagerCachedRecipe)o2).mod)) {
                return ((VillagerCachedRecipe)o1).mod.compareTo(((VillagerCachedRecipe)o2).mod);
            }
            return ((VillagerCachedRecipe)o1).profession.compareTo(((VillagerCachedRecipe)o2).profession);
        });
    }

    private void addRecipeInt(ArrayList<Pair<Pair<Pair<VillagerCachedRecipe.PositionedTradeItem, VillagerCachedRecipe.PositionedTradeItem>, VillagerCachedRecipe.PositionedTradeItem>, VillagerTrade>> tradeList, EntityVillager displayMob) {
        cachedRecipes.add(new VillagerCachedRecipe(tradeList, displayMob));
    }

    public TemplateRecipeHandler newInstance() {
        return new VillagerTradesHandler();
    }

    public String getOverlayIdentifier() {
        return "mobsinfo.villagertradeshandler";
    }

    public String getGuiTexture() {
        return "mobsinfo:textures/gui/VillagerTrades.png";
    }

    public String getRecipeName() {
        return "Villager Trades";
    }

    public VillagerTradesHandler() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new java.awt.Rectangle(7, 62, 16, 16), this.getOverlayIdentifier(), new Object[0]));
        if (!NEI_Config.isAdded) {
            FMLInterModComms.sendRuntimeMessage((Object)MobsInfo.instance, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("MobsInfo@" + this.getRecipeName() + "@" + this.getOverlayIdentifier()));
            GuiCraftingRecipe.craftinghandlers.add(this);
            GuiUsageRecipe.usagehandlers.add(this);
        }
        this.scrollbar = new Scrollbar(this, 0, 94);
    }

    public void drawBackground(int recipe) {
        int err;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)168, (int)105);
        VillagerCachedRecipe currentRecipe = (VillagerCachedRecipe)((Object)this.arecipes.get(recipe));
        this.scrollbar.beginBackground(recipe);
        this.recipeRects.clear();
        int x = 6;
        int y = 94;
        boolean second = false;
        for (int i = 0; i < currentRecipe.tradeList.size(); ++i) {
            GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)0, (int)192, (int)77, (int)18);
            this.recipeRects.put(new java.awt.Rectangle(x + 35, y, 24, 18), (VillagerTrade)((Pair)currentRecipe.tradeList.get(i)).getValue());
            if (!second) {
                x += 79;
                second = true;
                continue;
            }
            x = 6;
            y += 20;
            second = false;
        }
        this.scrollbar.reportMaxContentDrawn(y + 18);
        this.scrollbar.endBackground(recipe);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scale = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int width = scale.func_78326_a();
        int height = scale.func_78328_b();
        int mouseX = Mouse.getX() * width / mc.field_71443_c;
        int mouseZ = height - Mouse.getY() * height / mc.field_71440_d - 1;
        matrixBuffer.clear();
        GL11.glGetFloat((int)2982, (FloatBuffer)matrixBuffer);
        float x2 = matrixBuffer.get(12);
        float y2 = matrixBuffer.get(13);
        int stackdepth = GL11.glGetInteger((int)2979);
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        try {
            EntityVillager e = currentRecipe.displayMob;
            int mobx = 31;
            int moby = 50;
            e.func_70107_b(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v);
            e.field_70142_S = e.field_70165_t;
            e.field_70137_T = e.field_70163_u;
            e.field_70136_U = e.field_70161_v;
            Rectangle v = MobUtils.getMobSizeInGui((EntityLiving)e, mobx, moby, 20);
            float ylocal = (float)(v.getY() + v.getHeight()) - y2;
            float wantedy = 54.0f;
            float new_scale = 40.0f / (float)v.getHeight();
            float new_scale_x = 38.0f / (float)v.getWidth();
            if (new_scale_x < new_scale) {
                new_scale = new_scale_x;
            }
            new_scale = (float)Math.round(20.0f * new_scale) / 20.0f;
            float a = (float)moby - ylocal;
            float aa = a - a * new_scale;
            float aaa = wantedy - ylocal - aa;
            GuiInventory.func_147046_a((int)mobx, (int)((int)((float)moby + aaa)), (int)Math.round(20.0f * new_scale), (float)(x2 + (float)mobx - (float)mouseX), (float)(y2 + (float)moby - 25.0f - (float)mouseZ), (EntityLivingBase)e);
        }
        catch (Throwable ex) {
            Tessellator tes = Tessellator.field_78398_a;
            try {
                tes.func_78381_a();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GL11.glMatrixMode((int)5888);
        if ((stackdepth -= GL11.glGetInteger((int)2979)) < 0) {
            while (stackdepth < 0) {
                GL11.glPopMatrix();
                ++stackdepth;
            }
        }
        if (stackdepth > 0) {
            while (stackdepth > 0) {
                GL11.glPushMatrix();
                --stackdepth;
            }
            GL11.glLoadMatrix((FloatBuffer)matrixBuffer);
        }
        GL11.glPopAttrib();
        while ((err = GL11.glGetError()) != 0) {
            if (!Config.Debug.showRenderErrors) continue;
            LOG.error("Profession {} | GL ERROR: {} / {}", new Object[]{currentRecipe.displayMob.func_70946_n(), err, GLU.gluErrorString((int)err)});
        }
        GL11.glDisable((int)2929);
    }

    public void drawForeground(int recipe) {
        VillagerCachedRecipe currentRecipe = (VillagerCachedRecipe)((Object)this.arecipes.get(recipe));
        int y = 7;
        int yshift = 10;
        int x = 57;
        GuiDraw.drawString((String)(Translations.NAME.get() + currentRecipe.profession), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x && NEIClientUtils.shiftKey()) {
            GuiDraw.drawString((String)("ID: " + currentRecipe.professionID), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        }
        GuiDraw.drawString((String)(Translations.MOD.get() + currentRecipe.mod), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        this.scrollbar.beginForeground(recipe);
        this.scrollbar.endForeground(recipe);
    }

    @Override
    public Scrollbar getScrollbar() {
        return this.scrollbar;
    }

    @Override
    public List<PositionedStack> getAllItems(int recipe) {
        ArrayList<PositionedStack> ret = new ArrayList<PositionedStack>();
        ret.addAll(((VillagerCachedRecipe)((Object)this.arecipes.get(recipe))).getInputs());
        ret.addAll(((VillagerCachedRecipe)((Object)this.arecipes.get(recipe))).getOutputs());
        return ret;
    }

    public IUsageHandler getUsageAndCatalystHandler(String inputId, Object ... ingredients) {
        ItemStack candidate;
        TemplateRecipeHandler handler;
        if (inputId.equals("item") && RecipeCatalysts.containsCatalyst((IRecipeHandler)(handler = this.newInstance()), (ItemStack)(candidate = (ItemStack)ingredients[0]))) {
            handler.loadCraftingRecipes(this.getOverlayIdentifier(), new Object[]{null});
            return handler;
        }
        return this.getUsageHandler(inputId, ingredients);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            this.arecipes.addAll(cachedRecipes);
            return;
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (VillagerCachedRecipe r : cachedRecipes) {
            if (!r.contains(r.mOutputs, result)) continue;
            this.arecipes.add(r);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (VillagerCachedRecipe r : cachedRecipes) {
            if (!r.contains(r.mInputs, ingredient)) continue;
            this.arecipes.add(r);
        }
    }

    public VillagerTradesHandler addAllRecipes() {
        this.arecipes.addAll(cachedRecipes);
        return this;
    }

    public void onUpdate() {
        ++cycleTicksStatic;
        for (Integer recipe : ((GuiRecipe)Minecraft.func_71410_x().field_71462_r).getRecipeIndices()) {
            ((VillagerCachedRecipe)((Object)this.arecipes.get(recipe))).onUpdate();
        }
    }

    public boolean mouseScrolled(GuiRecipe<?> gui, int scroll, int recipe) {
        if (super.mouseScrolled(gui, scroll, recipe)) {
            return true;
        }
        return this.scrollbar.mouseScrolled(gui, scroll, recipe);
    }

    @Override
    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip, int recipe, int x, int y) {
        VillagerCachedRecipe currentRecipe = (VillagerCachedRecipe)((Object)this.arecipes.get(recipe));
        for (Map.Entry<java.awt.Rectangle, VillagerTrade> entry : this.recipeRects.entrySet()) {
            if (!entry.getKey().contains(x, y)) continue;
            currenttip.addAll(Arrays.asList(Translations.CHANCE.get(entry.getValue().getChance() * 100.0), Translations.REAL_CHANCE.get(entry.getValue().getChance() / (double)currentRecipe.tradeList.size() * 100.0)));
            break;
        }
        return currenttip;
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip, int recipe) {
        currenttip = super.handleTooltip(gui, currenttip, recipe);
        return this.scrollbar.handleTooltip(gui, currenttip, recipe);
    }

    class VillagerCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final ArrayList<Pair<Pair<Pair<PositionedTradeItem, PositionedTradeItem>, PositionedTradeItem>, VillagerTrade>> tradeList;
        private final ArrayList<PositionedStack> mOutputs;
        private final ArrayList<PositionedStack> mInputs;
        private final EntityVillager displayMob;
        private final int professionID;
        private final String profession;
        private final String mod;

        public VillagerCachedRecipe(ArrayList<Pair<Pair<Pair<PositionedTradeItem, PositionedTradeItem>, PositionedTradeItem>, VillagerTrade>> tradeList, EntityVillager displayMob) {
            super((TemplateRecipeHandler)VillagerTradesHandler.this);
            this.tradeList = tradeList;
            this.mOutputs = new ArrayList();
            this.mInputs = new ArrayList();
            for (Pair<Pair<Pair<PositionedTradeItem, PositionedTradeItem>, PositionedTradeItem>, VillagerTrade> trade : this.tradeList) {
                this.mOutputs.add((PositionedStack)((Pair)trade.getLeft()).getRight());
                this.mInputs.add((PositionedStack)((Pair)((Pair)trade.getLeft()).getLeft()).getLeft());
                if (((Pair)((Pair)trade.getLeft()).getLeft()).getRight() == null) continue;
                this.mInputs.add((PositionedStack)((Pair)((Pair)trade.getLeft()).getLeft()).getRight());
            }
            this.displayMob = displayMob;
            this.professionID = this.displayMob.func_70946_n();
            if (this.professionID >= 0 && this.professionID <= 4) {
                String professionString = vanillaVillagers[this.professionID];
                this.mod = "Minecraft";
                this.profession = StatCollector.func_94522_b((String)("description.villager.profession." + professionString)) ? StatCollector.func_74838_a((String)("description.villager.profession." + professionString)) : StringUtils.capitalize((String)professionString);
            } else {
                ResourceLocation villagerSkin = VillagerRegistry.getVillagerSkin((int)this.professionID, null);
                if (villagerSkin == null) {
                    this.mod = "Unknown";
                    this.profession = "Unknown-" + this.professionID;
                } else {
                    String professionString = "";
                    String path = villagerSkin.func_110623_a();
                    professionString = (path = path.substring(path.lastIndexOf(47) + 1)).indexOf(46) != -1 ? path.substring(0, path.lastIndexOf(46)) : path;
                    this.mod = villagerSkin.func_110624_b();
                    this.profession = StatCollector.func_94522_b((String)("description.villager.profession." + this.mod + '.' + professionString)) ? StatCollector.func_74838_a((String)("description.villager.profession." + this.mod + '.' + professionString)) : StringUtils.capitalize((String)professionString);
                }
            }
        }

        public PositionedStack getResult() {
            return null;
        }

        public void onUpdate() {
            if (!NEIClientUtils.shiftKey() && cycleTicksStatic % 10 == 0) {
                this.mOutputs.forEach(p -> p.setPermutationToRender(0));
                this.mInputs.forEach(p -> p.setPermutationToRender(0));
            }
        }

        public List<PositionedStack> getOutputs() {
            return this.mOutputs;
        }

        public List<PositionedStack> getInputs() {
            return this.mInputs;
        }

        public List<PositionedStack> getOtherStacks() {
            return Collections.emptyList();
        }

        public List<PositionedStack> getIngredients() {
            return Collections.emptyList();
        }

        static class PositionedTradeItem
        extends PositionedStack {
            private final VillagerTrade.TradeItem tradeItem;
            private final List<Integer> possibleSizes;
            private final Random rand;

            public PositionedTradeItem(VillagerTrade.TradeItem tradeItem, int x, int y) {
                super((Object)tradeItem.stack, x, y, false);
                this.tradeItem = tradeItem;
                this.rand = new FastRandom();
                this.possibleSizes = tradeItem.possibleSizes == null ? null : new ArrayList<Integer>(tradeItem.possibleSizes);
                this.setPermutationToRender(0);
            }

            public void setPermutationToRender(int index) {
                if (this.item == null) {
                    this.item = this.items[0].func_77946_l();
                }
                if (this.tradeItem == null) {
                    return;
                }
                if (this.tradeItem.enchantability != null) {
                    if (this.item.func_77973_b() == Items.field_151134_bR) {
                        this.item = this.items[0].func_77946_l();
                    }
                    if (this.item.func_77942_o()) {
                        this.item.func_77978_p().func_82580_o("ench");
                    }
                    try {
                        EnchantmentHelper.func_77504_a((Random)this.rand, (ItemStack)this.item, (int)this.tradeItem.enchantability);
                    }
                    catch (Exception e) {
                        GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Item)this.item.func_77973_b());
                        LOG.error("addRandomEnchantment failed on {}:{}, marking this item as not enchantable! Printing stacktrace:", new Object[]{ui.toString(), this.item.func_77960_j()});
                        e.printStackTrace();
                        this.tradeItem.enchantability = null;
                    }
                }
                if (this.possibleSizes != null) {
                    this.item.field_77994_a = this.possibleSizes.get(this.rand.nextInt(this.possibleSizes.size()));
                }
            }
        }
    }

    static enum Translations {
        NAME,
        MOD,
        CHANCE,
        REAL_CHANCE;

        final String key = "mobsinfo.villagertradeshandler." + this.name().toLowerCase();

        public String get() {
            return StatCollector.func_74838_a((String)this.key);
        }

        public List<String> getAllLines() {
            ArrayList<String> lines = new ArrayList<String>(Collections.singletonList(StatCollector.func_74838_a((String)this.key)));
            int i = 1;
            while (StatCollector.func_94522_b((String)(this.key + "_" + i))) {
                lines.add(StatCollector.func_74838_a((String)(this.key + "_" + i++)));
            }
            return lines;
        }

        public String get(Object ... args) {
            return TranslationHelper.translateFormattedFixed(this.key, args);
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.get();
        }
    }
}

