/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.nei.scrollable;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import com.kuba6000.mobsinfo.mixin.early.minecraft.GuiAccessor;
import com.kuba6000.mobsinfo.mixin.early.minecraft.GuiContainerAccessor;
import com.kuba6000.mobsinfo.nei.scrollable.IScrollableGUI;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class Scrollbar {
    public int x;
    public int y;
    public int width;
    public int height;
    public boolean dynamicHeight;
    public int scrollOffset = 0;
    public int yMax;
    public WeakReference<IScrollableGUI> myGUI;
    private int oldRecipe = -1;

    public Scrollbar(IScrollableGUI myGUI, int x, int y) {
        this.myGUI = new WeakReference<IScrollableGUI>(myGUI);
        this.x = x;
        this.y = y;
        this.width = 168 - x;
        this.dynamicHeight = true;
    }

    public Scrollbar(IScrollableGUI myGUI, int x, int y, int width, int height) {
        this.myGUI = new WeakReference<IScrollableGUI>(myGUI);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void reportMaxContentDrawn(int yMax) {
        this.yMax = yMax;
    }

    public boolean mouseScrolled(GuiRecipe<?> gui, int scroll, int recipe) {
        Point mouse = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        int bot = this.y + (this.dynamicHeight ? ((GuiContainerAccessor)gui).getYSize() - offset.y - 5 - this.y : this.height);
        if (!NEIClientUtils.shiftKey()) {
            if (this.yMax > bot && new Rectangle(((GuiContainerAccessor)gui).getGuiLeft() + offset.x + this.x, ((GuiContainerAccessor)gui).getGuiTop() + offset.y + this.y, this.width, this.dynamicHeight ? ((GuiContainerAccessor)gui).getYSize() - offset.y - 5 - this.y : this.height).contains(mouse)) {
                bot -= this.scrollOffset;
                if (scroll < 0) {
                    int maxScroll = this.yMax - bot;
                    if (maxScroll > 0) {
                        this.scrollOffset += Math.max(-maxScroll, 10 * scroll);
                    }
                } else if (this.scrollOffset < 0) {
                    this.scrollOffset += Math.min(-this.scrollOffset, 10 * scroll);
                }
                return true;
            }
        } else {
            Point relMouse = new Point(mouse.x - ((GuiContainerAccessor)gui).getGuiLeft() - offset.x, mouse.y - ((GuiContainerAccessor)gui).getGuiTop() - offset.y);
            PositionedStack overStack = this.getItemUnderMouse(recipe, relMouse.x, relMouse.y);
            if (overStack != null) {
                overStack.setPermutationToRender(0);
                return true;
            }
            return false;
        }
        return false;
    }

    public void beginScissor(int recipe) {
        int ysize;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)this.scrollOffset, (float)0.0f);
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int scaleFactor = res.func_78325_e();
        GuiRecipe gui = (GuiRecipe)mc.field_71462_r;
        Point offset = gui.getRecipePosition(recipe);
        if (this.dynamicHeight) {
            ysize = ((GuiContainerAccessor)gui).getYSize();
            ysize -= offset.y + 5;
        } else {
            ysize = this.height + this.y;
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((((GuiContainerAccessor)gui).getGuiLeft() + this.x) * scaleFactor), (int)((res.func_78328_b() - (((GuiContainerAccessor)gui).getGuiTop() + offset.y + ysize)) * scaleFactor), (int)(this.width * scaleFactor), (int)((this.dynamicHeight ? ysize - this.y : this.height) * scaleFactor));
    }

    public void endScissor() {
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
    }

    public void beginBackground(int recipe) {
        if (this.oldRecipe != recipe) {
            this.oldRecipe = recipe;
            this.scrollOffset = 0;
            this.yMax = 0;
        }
        this.beginScissor(recipe);
    }

    public void endBackground(int recipe) {
        this.endScissor();
        GuiRecipe gui = (GuiRecipe)Minecraft.func_71410_x().field_71462_r;
        Point offset = gui.getRecipePosition(recipe);
        int bot = this.y + (this.dynamicHeight ? ((GuiContainerAccessor)gui).getYSize() - offset.y - 5 - this.y : this.height);
        if (this.yMax > bot) {
            GuiDraw.changeTexture((String)"mobsinfo:textures/gui/Scrollbar.png");
            int ySize = this.dynamicHeight ? ((GuiContainerAccessor)gui).getYSize() - offset.y - 5 - this.y : this.height;
            GuiDraw.drawTexturedModalRect((int)(this.x + this.width + 4), (int)this.y, (int)0, (int)0, (int)10, (int)ySize);
            double filled = (double)ySize / (double)(ySize + (this.yMax - bot));
            GuiDraw.drawTexturedModalRect((int)(this.x + this.width + 4 + 2), (int)(this.y + 2 + (int)((double)(-this.scrollOffset) * filled)), (int)10, (int)0, (int)6, (int)((int)((double)(ySize - 4) * filled)));
        }
    }

    public void beginForeground(int recipe) {
        this.beginScissor(recipe);
    }

    public void endForeground(int recipe) {
        this.drawForeground(recipe);
        this.endScissor();
    }

    private void drawForeground(int recipe) {
        Point mouse = GuiDraw.getMousePosition();
        GuiRecipe gui = (GuiRecipe)Minecraft.func_71410_x().field_71462_r;
        Point offset = gui.getRecipePosition(recipe);
        int x = mouse.x - (offset.x + ((GuiContainerAccessor)gui).getGuiLeft());
        int y = mouse.y - (offset.y + ((GuiContainerAccessor)gui).getGuiTop());
        GL11.glDisable((int)2896);
        for (PositionedStack input : ((IScrollableGUI)this.myGUI.get()).getAllItems(recipe)) {
            if (new Rectangle(input.relx, input.rely + this.scrollOffset, 16, 16).contains(x, y)) {
                GL11.glDisable((int)2929);
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                ((GuiAccessor)gui).callDrawGradientRect(input.relx, input.rely, input.relx + 16, input.rely + 16, -2130706433, -2130706433);
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GL11.glEnable((int)2929);
            }
            GuiContainerManager.drawItem((int)input.relx, (int)input.rely, (ItemStack)input.item);
        }
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public PositionedStack getItemUnderMouse(int recipe, int x, int y) {
        for (PositionedStack item : ((IScrollableGUI)this.myGUI.get()).getAllItems(recipe)) {
            if (!new Rectangle(item.relx, item.rely + this.scrollOffset, 16, 16).contains(x, y)) continue;
            return item;
        }
        return null;
    }

    public ItemStack getStackUnderMouse(int recipe, int x, int y) {
        PositionedStack stack = this.getItemUnderMouse(recipe, x, y);
        return stack == null ? null : stack.item;
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip, int recipe) {
        Point mouse = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        int x = mouse.x - (offset.x + ((GuiContainerAccessor)gui).getGuiLeft());
        int y = mouse.y - (offset.y + ((GuiContainerAccessor)gui).getGuiTop()) - this.scrollOffset;
        return ((IScrollableGUI)this.myGUI.get()).handleTooltip(gui, currenttip, recipe, x, y);
    }
}

