/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.fluids;

import com.google.common.primitives.Ints;
import com.gtnewhorizons.modularui.api.fluids.IFluidTankLong;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidTankLong
implements IFluidTankLong {
    private Fluid fluid;
    private long storedAmount;
    private long capacity;
    private FluidStack internal;
    private boolean locked;
    private NBTTagCompound tag;

    public FluidTankLong(Fluid fluid, long capacity, long amount) {
        this.fluid = fluid;
        this.storedAmount = amount;
        this.capacity = capacity;
        if (fluid == null) {
            return;
        }
        this.internal = new FluidStack(fluid, Ints.saturatedCast((long)amount));
    }

    public FluidTankLong(Fluid fluid, long capacity) {
        this(fluid, capacity, 0L);
    }

    public FluidTankLong(long capacity) {
        this(null, capacity);
    }

    public FluidTankLong(FluidStack fluid, long capacity, long amount) {
        this(fluid != null ? fluid.getFluid() : null, capacity, amount);
    }

    @Override
    public FluidStack getFluidStack() {
        if (this.storedAmount <= 0L || this.fluid == null) {
            this.fluid = null;
            this.internal = null;
            this.storedAmount = 0L;
            return null;
        }
        if (this.internal == null) {
            this.internal = new FluidStack(this.fluid, 0);
        }
        this.internal.amount = Ints.saturatedCast((long)this.storedAmount);
        return this.internal;
    }

    @Override
    public Fluid getStoredFluid() {
        return this.fluid;
    }

    @Override
    public long getCapacityLong() {
        return this.capacity;
    }

    @Override
    public long getRealCapacityLong() {
        return this.getCapacityLong();
    }

    @Override
    public long getFluidAmountLong() {
        return this.storedAmount;
    }

    @Override
    public long fill(Fluid fluid, long amount, boolean doFill) {
        if (this.fluid != null && this.fluid != fluid || fluid == null) {
            return 0L;
        }
        if (!doFill) {
            return Math.min(this.capacity - this.storedAmount, amount);
        }
        long amountFilled = Math.min(this.capacity - this.storedAmount, amount);
        this.storedAmount += amountFilled;
        this.fluid = fluid;
        return amountFilled;
    }

    @Override
    public FluidStack drain(long amount, boolean doDrain) {
        if (this.fluid == null) {
            return null;
        }
        if (!doDrain) {
            return new FluidStack(this.fluid, Ints.saturatedCast((long)Math.min(this.storedAmount, amount)));
        }
        long amountDrained = Math.min(Integer.MAX_VALUE, Math.min(this.storedAmount, amount));
        this.storedAmount -= amountDrained;
        FluidStack fluidDrained = new FluidStack(this.fluid, Ints.saturatedCast((long)amountDrained));
        if (this.storedAmount <= 0L && !this.locked) {
            this.fluid = null;
            this.internal = null;
        }
        return fluidDrained;
    }

    @Override
    public void setFluid(Fluid fluid, long amount) {
        this.fluid = fluid;
        this.storedAmount = amount;
        if (fluid == null) {
            this.internal = null;
            return;
        }
        this.internal = new FluidStack(this.fluid, Ints.saturatedCast((long)this.storedAmount));
    }

    public void setFluid(Fluid fluid) {
        this.setFluid(fluid, 0L);
    }

    @Override
    public void loadFromNBT(NBTTagCompound nbt) {
        this.fluid = nbt.func_74764_b("FluidName") ? FluidRegistry.getFluid((String)nbt.func_74779_i("FluidName")) : null;
        this.capacity = nbt.func_74763_f("Capacity");
        this.storedAmount = nbt.func_74763_f("StoredAmount");
    }

    @Override
    public void saveToNBT(NBTTagCompound nbt) {
        if (this.fluid != null) {
            nbt.func_74778_a("FluidName", FluidRegistry.getFluidName((Fluid)this.getStoredFluid()));
        }
        nbt.func_74772_a("StoredAmount", this.getFluidAmountLong());
        nbt.func_74772_a("Capacity", this.getCapacityLong());
        if (this.tag != null) {
            nbt.func_74782_a("Tag", (NBTBase)this.tag);
        }
    }

    @Override
    public boolean isFluidEqual(@Nullable IFluidTankLong cached) {
        return cached != null && this.getFluid() == cached.getFluid();
    }

    @Override
    public FluidTankLong copy() {
        return new FluidTankLong(this.fluid, this.capacity, this.storedAmount);
    }
}

