/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.forge;

import com.gtnewhorizons.modularui.api.forge.IItemHandler;
import com.gtnewhorizons.modularui.api.forge.PlayerMainInvWrapper;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemHandlerHelper {
    public static ItemStack insertItem(IItemHandler dest, ItemStack stack, boolean simulate) {
        if (dest != null && stack != null) {
            for (int i = 0; i < dest.getSlots(); ++i) {
                if ((stack = dest.insertItem(i, stack, simulate)) != null) continue;
                return null;
            }
            return stack;
        }
        return stack;
    }

    public static boolean canItemStacksStack(ItemStack a, ItemStack b) {
        if (a != null && a.func_77969_a(b) && a.func_77942_o() == b.func_77942_o()) {
            return !a.func_77942_o() || a.func_77978_p().equals((Object)b.func_77978_p());
        }
        return false;
    }

    public static boolean canItemStacksStackRelaxed(ItemStack a, ItemStack b) {
        if (a != null && b != null && a.func_77973_b() == b.func_77973_b()) {
            if (!a.func_77985_e()) {
                return false;
            }
            if (a.func_77981_g() && a.func_77960_j() != b.func_77960_j()) {
                return false;
            }
            if (a.func_77942_o() != b.func_77942_o()) {
                return false;
            }
            return !a.func_77942_o() || a.func_77978_p().equals((Object)b.func_77978_p());
        }
        return false;
    }

    public static ItemStack copyStackWithSize(ItemStack itemStack, int size) {
        if (size == 0) {
            return null;
        }
        ItemStack copy = itemStack.func_77946_l();
        copy.field_77994_a = size;
        return copy;
    }

    public static ItemStack insertItemStacked(IItemHandler inventory, ItemStack stack, boolean simulate) {
        if (inventory != null && stack != null) {
            ItemStack slot;
            int i;
            if (!stack.func_77985_e()) {
                return ItemHandlerHelper.insertItem(inventory, stack, simulate);
            }
            int sizeInventory = inventory.getSlots();
            for (i = 0; !(i >= sizeInventory || ItemHandlerHelper.canItemStacksStackRelaxed(slot = inventory.getStackInSlot(i), stack) && (stack = inventory.insertItem(i, stack, simulate)) == null); ++i) {
            }
            if (stack != null) {
                for (i = 0; i < sizeInventory && (inventory.getStackInSlot(i) != null || (stack = inventory.insertItem(i, stack, simulate)) != null); ++i) {
                }
            }
            return stack;
        }
        return stack;
    }

    public static void giveItemToPlayer(EntityPlayer player, ItemStack stack) {
        ItemHandlerHelper.giveItemToPlayer(player, stack, -1);
    }

    public static void giveItemToPlayer(EntityPlayer player, ItemStack stack, int preferredSlot) {
        if (stack != null) {
            PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.field_71071_by);
            World world = player.field_70170_p;
            ItemStack remainder = stack;
            if (preferredSlot >= 0 && preferredSlot < inventory.getSlots()) {
                remainder = inventory.insertItem(preferredSlot, stack, false);
            }
            if (remainder != null) {
                remainder = ItemHandlerHelper.insertItemStacked(inventory, remainder, false);
            }
            if (remainder == null || remainder.field_77994_a != stack.field_77994_a) {
                world.func_72956_a((Entity)player, "random.pop", 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            if (remainder != null && !world.field_72995_K) {
                EntityItem entityitem = new EntityItem(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, remainder);
                entityitem.field_145804_b = 40;
                entityitem.field_70159_w = 0.0;
                entityitem.field_70179_y = 0.0;
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public static int calcRedstoneFromInventory(@Nullable IItemHandler inv) {
        if (inv == null) {
            return 0;
        }
        int itemsFound = 0;
        float proportion = 0.0f;
        for (int j = 0; j < inv.getSlots(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack == null) continue;
            proportion += (float)itemstack.field_77994_a / (float)Math.min(inv.getSlotLimit(j), itemstack.func_77976_d());
            ++itemsFound;
        }
        return MathHelper.func_76141_d((float)((proportion /= (float)inv.getSlots()) * 14.0f)) + (itemsFound > 0 ? 1 : 0);
    }
}

