/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.common.internal.JsonHelper;
import com.gtnewhorizons.modularui.common.widget.SyncedWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CycleButtonWidget
extends SyncedWidget
implements Interactable {
    protected int state = 0;
    protected int length = 1;
    protected Consumer<Integer> setter;
    protected Supplier<Integer> getter;
    protected Function<Integer, IDrawable> textureGetter;
    protected Function<Integer, IDrawable[]> backgroundGetter;
    protected IDrawable texture = IDrawable.EMPTY;
    private final List<List<Text>> stateTooltip = new ArrayList<List<Text>>();
    private boolean playClickSound = true;

    @Override
    public void readJson(JsonObject json, String type) {
        super.readJson(json, type);
        this.length = JsonHelper.getInt(json, 1, "length", "size");
        this.state = JsonHelper.getInt(json, 0, "defaultState");
        if (json.has("texture")) {
            JsonElement element = json.get("texture");
            if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                this.length = array.size();
                IDrawable[] textures = new IDrawable[this.length];
                for (int i = 0; i < array.size(); ++i) {
                    JsonElement element1 = array.get(i);
                    if (element1.isJsonObject()) {
                        textures[i] = IDrawable.ofJson(element1.getAsJsonObject());
                        continue;
                    }
                    textures[i] = IDrawable.EMPTY;
                    ModularUI.logger.error("Texture needs to be a json object");
                }
                this.textureGetter = val -> textures[val];
            } else if (element.isJsonObject()) {
                IDrawable drawable = IDrawable.ofJson(element.getAsJsonObject());
                if (drawable instanceof UITexture) {
                    this.setTexture((UITexture)drawable);
                } else {
                    this.textureGetter = val -> drawable;
                }
            }
        }
    }

    @Override
    public void onInit() {
        if (this.setter == null || this.getter == null) {
            ModularUI.logger.warn("{} was not properly initialised!", new Object[]{this});
            return;
        }
        if (this.textureGetter == null) {
            ModularUI.logger.warn("Texture Getter of {} was not set!", new Object[]{this});
            this.textureGetter = val -> IDrawable.EMPTY;
        }
        this.setState(this.getter.get(), false, false);
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        return new Size(20, 20);
    }

    @Override
    @Nullable
    public String getBackgroundColorKey() {
        return "button";
    }

    public void next() {
        if (++this.state == this.length) {
            this.state = 0;
        }
        this.setState(this.state, true, true);
    }

    public void prev() {
        if (--this.state == -1) {
            this.state = this.length - 1;
        }
        this.setState(this.state, true, true);
    }

    public void setState(int state, boolean sync, boolean setSource) {
        if (state >= this.length) {
            throw new IndexOutOfBoundsException("CycleButton state out of bounds");
        }
        this.state = state;
        if (sync) {
            if (this.isClient()) {
                if (this.syncsToServer()) {
                    this.syncToServer(1, buffer -> buffer.func_150787_b(state));
                }
            } else {
                this.syncToClient(1, buffer -> buffer.func_150787_b(state));
            }
        }
        if (setSource) {
            this.setter.accept(this.state);
        }
        if (this.isClient()) {
            this.texture = this.textureGetter.apply(this.state);
            if (this.backgroundGetter != null) {
                this.setBackground(this.backgroundGetter.apply(this.state));
            }
        }
    }

    @Override
    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        switch (buttonId) {
            case 0: {
                this.next();
                if (this.playClickSound) {
                    Interactable.playButtonClickSound();
                }
                return Interactable.ClickResult.ACCEPT;
            }
            case 1: {
                this.prev();
                if (this.playClickSound) {
                    Interactable.playButtonClickSound();
                }
                return Interactable.ClickResult.ACCEPT;
            }
        }
        return Interactable.ClickResult.ACKNOWLEDGED;
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        if (this.syncsToClient()) {
            int actualValue = this.getter.get();
            if (init || actualValue != this.state) {
                this.setState(actualValue, true, false);
                this.markForUpdate();
            }
        }
    }

    @Override
    public void draw(float partialTicks) {
        this.texture.applyThemeColor();
        this.texture.draw(Pos2d.ZERO, this.getSize(), partialTicks);
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) {
        if (id == 1) {
            this.setState(buf.func_150792_a(), false, true);
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) {
        if (id == 1) {
            this.setState(buf.func_150792_a(), false, true);
            this.markForUpdate();
        }
    }

    @Override
    public boolean hasTooltip() {
        return super.hasTooltip() || this.stateTooltip.size() > this.state && !this.stateTooltip.get(this.state).isEmpty();
    }

    @Override
    public List<Text> getTooltip() {
        List<Text> texts = super.getTooltip();
        if (texts.isEmpty()) {
            return this.stateTooltip.get(this.state);
        }
        texts.addAll((Collection<Text>)this.stateTooltip.get(this.state));
        return texts;
    }

    public int getState() {
        return this.state;
    }

    public CycleButtonWidget setSetter(Consumer<Integer> setter) {
        this.setter = setter;
        return this;
    }

    public CycleButtonWidget setGetter(Supplier<Integer> getter) {
        this.getter = getter;
        return this;
    }

    public <T extends Enum<T>> CycleButtonWidget setForEnum(Class<T> clazz, Supplier<T> getter, Consumer<T> setter) {
        this.setSetter(val -> setter.accept(((Enum[])clazz.getEnumConstants())[val]));
        this.setGetter(() -> ((Enum)getter.get()).ordinal());
        this.setLength(((Enum[])clazz.getEnumConstants()).length);
        return this;
    }

    public CycleButtonWidget setToggle(Supplier<Boolean> getter, Consumer<Boolean> setter) {
        this.setSetter(val -> setter.accept(val == 1));
        this.setGetter(() -> (Boolean)getter.get() != false ? 1 : 0);
        this.setLength(2);
        return this;
    }

    public CycleButtonWidget setTextureGetter(Function<Integer, IDrawable> textureGetter) {
        this.textureGetter = textureGetter;
        return this;
    }

    public CycleButtonWidget setTexture(UITexture texture) {
        return this.setTextureGetter(val -> {
            float a = 1.0f / (float)this.length;
            return texture.getSubArea(0.0f, (float)val.intValue() * a, 1.0f, (float)val.intValue() * a + a);
        });
    }

    public CycleButtonWidget setStaticTexture(IDrawable texture) {
        return this.setTextureGetter(val -> texture);
    }

    public CycleButtonWidget setVariableBackgroundGetter(Function<Integer, IDrawable[]> backgroundGetter) {
        this.backgroundGetter = backgroundGetter;
        return this;
    }

    public CycleButtonWidget setVariableBackground(UITexture ... textures) {
        return this.setVariableBackgroundGetter(val -> Arrays.stream(textures).map(texture -> {
            float a = 1.0f / (float)this.length;
            return texture.getSubArea(0.0f, (float)val.intValue() * a, 1.0f, (float)val.intValue() * a + a);
        }).collect(Collectors.toList()).toArray(new IDrawable[0]));
    }

    public CycleButtonWidget addTooltip(int state, Text tooltip) {
        if (state >= this.stateTooltip.size() || state < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.stateTooltip.get(state).add(tooltip);
        return this;
    }

    public CycleButtonWidget addTooltip(int state, String tooltip) {
        return this.addTooltip(state, new Text(tooltip).color(Color.WHITE.normal));
    }

    public CycleButtonWidget addTooltip(Function<Integer, String> tooltipFunc) {
        for (int i = 0; i < this.length; ++i) {
            this.addTooltip(i, tooltipFunc.apply(i));
        }
        return this;
    }

    public CycleButtonWidget setLength(int length) {
        this.length = length;
        this.setupTooltip();
        return this;
    }

    public CycleButtonWidget setPlayClickSound(boolean playClickSound) {
        this.playClickSound = playClickSound;
        return this;
    }

    protected void setupTooltip() {
        while (this.stateTooltip.size() < this.length) {
            this.stateTooltip.add(new ArrayList());
        }
        while (this.stateTooltip.size() > this.length) {
            this.stateTooltip.remove(this.stateTooltip.size() - 1);
        }
    }
}

