/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ListWidget;
import com.gtnewhorizons.modularui.common.widget.SortableListItem;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SortableListWidget<T>
extends ListWidget {
    private final Map<T, SortableListItem<T>> widgetMap = new HashMap<T, SortableListItem<T>>();
    private final List<T> startValues;
    private Function<T, Widget> widgetCreator = t -> new TextWidget(t.toString());
    private Consumer<List<T>> saveFunction = list -> {};
    private Consumer<T> onRemoveElement = t -> {};
    private boolean elementsRemovable = false;

    public static <T> SortableListWidget<T> removable(Collection<T> allValues, List<T> startValues) {
        return new SortableListWidget<T>(true, allValues, startValues);
    }

    private SortableListWidget(boolean removable, Collection<T> allValues, List<T> startValues) {
        this.elementsRemovable = removable;
        for (T t2 : allValues) {
            this.widgetMap.put(t2, null);
        }
        this.startValues = new ArrayList<T>(startValues);
    }

    public SortableListWidget(List<T> startValues) {
        this(false, startValues, startValues);
    }

    @Override
    public void initChildren() {
        super.initChildren();
        this.children.clear();
        int i = 0;
        for (T t : this.widgetMap.keySet()) {
            SortableListItem<T> listItem = new SortableListItem<T>(t);
            listItem.init(this);
            listItem.setCurrentIndex(i++);
            this.widgetMap.put(t, listItem);
            this.children.add(listItem);
        }
    }

    @Override
    public void onFirstRebuild() {
        this.children.clear();
        for (T t : this.startValues) {
            SortableListItem<T> listItem = this.widgetMap.get(t);
            if (listItem == null) {
                ModularUI.logger.error("Unexpected error: Could not find sortable list item for {}!", new Object[]{t});
                continue;
            }
            this.children.add(listItem);
        }
        this.assignIndexes();
        this.layoutChildren(0, 0);
        this.onRebuild();
    }

    @Override
    public void onPause() {
        this.saveFunction.accept(this.createElements());
    }

    public List<T> createElements() {
        return this.children.stream().map(widget -> ((SortableListItem)widget).getValue()).collect(Collectors.toList());
    }

    protected void removeElement(int index) {
        SortableListItem item = (SortableListItem)this.children.remove(index);
        this.onRemoveElement.accept(item.getValue());
        this.assignIndexes();
        this.layoutChildren(0, 0);
        this.onRebuild();
    }

    protected void moveElementUp(int index) {
        if (index > 0) {
            Widget widget = (Widget)this.children.remove(index);
            this.children.add(index - 1, widget);
            this.assignIndexes();
            this.layoutChildren(0, 0);
            this.onRebuild();
        }
    }

    protected void moveElementDown(int index) {
        if (index < this.children.size() - 1) {
            Widget widget = (Widget)this.children.remove(index);
            this.children.add(index + 1, widget);
            this.assignIndexes();
            this.layoutChildren(0, 0);
            this.onRebuild();
        }
    }

    protected void putAtIndex(int index, int toIndex) {
        Widget widget = (Widget)this.children.remove(index);
        this.children.add(toIndex, widget);
        this.assignIndexes();
        this.checkNeedsRebuild();
    }

    protected void assignIndexes() {
        for (int i = 0; i < this.children.size(); ++i) {
            ((SortableListItem)this.children.get(i)).setCurrentIndex(i);
        }
    }

    public Function<T, Widget> getWidgetCreator() {
        return this.widgetCreator;
    }

    public Consumer<T> getOnRemoveElement() {
        return this.onRemoveElement;
    }

    public boolean areElementsRemovable() {
        return this.elementsRemovable;
    }

    public void addElement(T t) {
        if (!this.isInitialised()) {
            throw new IllegalStateException("List needs to be initialised to add elements dynamically.");
        }
        if (!this.widgetMap.containsKey(t)) {
            throw new NoSuchElementException("This list widget was not initialised with the value " + t);
        }
        SortableListItem<T> listItem = this.widgetMap.get(t);
        listItem.setActive(true);
        listItem.setEnabled(true);
        this.children.add(listItem);
        this.assignIndexes();
        this.checkNeedsRebuild();
    }

    public SortableListWidget<T> setWidgetCreator(Function<T, Widget> widgetCreator) {
        this.widgetCreator = widgetCreator;
        return this;
    }

    public SortableListWidget<T> setSaveFunction(Consumer<List<T>> saveFunction) {
        this.saveFunction = saveFunction;
        return this;
    }

    public SortableListWidget<T> setElementsRemovable(boolean elementsRemovable) {
        this.elementsRemovable = elementsRemovable;
        return this;
    }

    public SortableListWidget<T> setOnRemoveElement(Consumer<T> onRemoveElement) {
        this.onRemoveElement = onRemoveElement;
        return this;
    }
}

