/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.animation;

import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface IAnimator {
    @Nullable
    public IAnimator getParent();

    default public void animate(boolean reverse) {
        this.reset(reverse);
        this.resume(reverse);
    }

    default public void animate() {
        this.animate(false);
    }

    public void stop(boolean var1);

    public void pause();

    public void resume(boolean var1);

    public void reset(boolean var1);

    default public void reset() {
        this.reset(false);
    }

    @ApiStatus.OverrideOnly
    public int advance(int var1);

    public boolean isPaused();

    public boolean isAnimating();

    public boolean isAnimatingReverse();

    public boolean hasProgressed();

    default public boolean isAnimatingForward() {
        return this.isAnimating() && !this.isAnimatingReverse();
    }

    public static int getTimeDiff(long startTime) {
        return IAnimator.getTimeDiff(startTime, Minecraft.func_71386_F());
    }

    public static int getTimeDiff(long startTime, long currentTime) {
        long elapsedTime = Math.abs(currentTime - startTime);
        return (int)Math.min(Integer.MAX_VALUE, elapsedTime);
    }
}

