/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.factory.AbstractUIFactory;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import com.cleanroommc.modularui.factory.TileEntityGuiFactory;
import com.cleanroommc.modularui.utils.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class SidedTileEntityGuiFactory
extends AbstractUIFactory<SidedPosGuiData> {
    public static final SidedTileEntityGuiFactory INSTANCE = new SidedTileEntityGuiFactory();

    public <T extends TileEntity> void open(EntityPlayer player, T tile, ForgeDirection facing) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(facing);
        TileEntityGuiFactory.verifyTile(player, tile);
        SidedPosGuiData data = new SidedPosGuiData(player, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, facing);
        GuiManager.open(this, data, (EntityPlayerMP)player);
    }

    public void open(EntityPlayer player, int x, int y, int z, ForgeDirection facing) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(facing);
        SidedPosGuiData data = new SidedPosGuiData(player, x, y, z, facing);
        GuiManager.open(this, data, (EntityPlayerMP)player);
    }

    @SideOnly(value=Side.CLIENT)
    public <T extends TileEntity> void openClient(T tile, ForgeDirection facing) {
        Objects.requireNonNull(facing);
        TileEntityGuiFactory.verifyTile((EntityPlayer)Platform.getClientPlayer(), tile);
        SidedPosGuiData data = new SidedPosGuiData((EntityPlayer)Platform.getClientPlayer(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, facing);
        GuiManager.openFromClient(this, data);
    }

    @SideOnly(value=Side.CLIENT)
    public void openClient(int x, int y, int z, ForgeDirection facing) {
        Objects.requireNonNull(facing);
        SidedPosGuiData data = new SidedPosGuiData((EntityPlayer)Platform.getClientPlayer(), x, y, z, facing);
        GuiManager.openFromClient(this, data);
    }

    private SidedTileEntityGuiFactory() {
        super("mui:sided_tile");
    }

    @Override
    @NotNull
    public IGuiHolder<SidedPosGuiData> getGuiHolder(SidedPosGuiData data) {
        return Objects.requireNonNull(this.castGuiHolder(data.getTileEntity()), "Found TileEntity is not a gui holder!");
    }

    @Override
    public boolean canInteractWith(EntityPlayer player, SidedPosGuiData guiData) {
        return player == guiData.getPlayer() && guiData.getTileEntity() != null && guiData.getSquaredDistance((Entity)player) <= 64.0;
    }

    @Override
    public void writeGuiData(SidedPosGuiData guiData, PacketBuffer buffer) {
        buffer.func_150787_b(guiData.getX());
        buffer.func_150787_b(guiData.getY());
        buffer.func_150787_b(guiData.getZ());
        buffer.writeByte(guiData.getSide().ordinal());
    }

    @Override
    @NotNull
    public SidedPosGuiData readGuiData(EntityPlayer player, PacketBuffer buffer) {
        return new SidedPosGuiData(player, buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a(), ForgeDirection.getOrientation((int)buffer.readByte()));
    }
}

