/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen.viewport;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.screen.ClientScreenHandler;
import com.cleanroommc.modularui.screen.viewport.GuiViewportStack;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.widget.sizer.Area;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiContext
extends GuiViewportStack {
    private final Area screenArea = new Area();
    private int mouseX;
    private int mouseY;
    private int mouseButton;
    private int mouseWheel;
    private char typedChar;
    private int keyCode;
    private float partialTicks;
    private long tick = 0L;
    private int currentDrawingZ = 0;

    public static GuiContext getDefault() {
        return ClientScreenHandler.getBestContext();
    }

    public boolean isAbove(IGuiElement widget) {
        return this.isMouseAbove(widget.getArea());
    }

    public boolean isMouseAbove(IGuiElement widget) {
        return this.isMouseAbove(widget.getArea());
    }

    public boolean isMouseAbove(Area area) {
        return area.isInside(this.mouseX, this.mouseY);
    }

    @ApiStatus.Internal
    public void updateState(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.partialTicks = partialTicks;
    }

    @ApiStatus.Internal
    public void updateEventState() {
        this.mouseButton = Mouse.getEventButton();
        this.mouseWheel = Mouse.getEventDWheel();
        this.keyCode = Keyboard.getEventKey();
        this.typedChar = Keyboard.getEventCharacter();
    }

    @ApiStatus.Internal
    public void updateScreenArea(int w, int h) {
        this.screenArea.set(0, 0, w, h);
        this.screenArea.rx = 0;
        this.screenArea.ry = 0;
    }

    public void updateZ(int z) {
        this.currentDrawingZ = z;
    }

    @SideOnly(value=Side.CLIENT)
    public Minecraft getMC() {
        return Minecraft.func_71410_x();
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer() {
        return MCHelper.getFontRenderer();
    }

    public void tick() {
        ++this.tick;
    }

    public Area getScreenArea() {
        return this.screenArea;
    }

    public long getTick() {
        return this.tick;
    }

    public int getMouseX() {
        return this.unTransformX(this.mouseX, this.mouseY);
    }

    public int getMouseY() {
        return this.unTransformY(this.mouseX, this.mouseY);
    }

    public int getMouse(GuiAxis axis) {
        return axis.isHorizontal() ? this.getMouseX() : this.getMouseY();
    }

    public int getAbsMouseX() {
        return this.mouseX;
    }

    public int getAbsMouseY() {
        return this.mouseY;
    }

    public int getAbsMouse(GuiAxis axis) {
        return axis.isHorizontal() ? this.getAbsMouseX() : this.getAbsMouseY();
    }

    public int getMouseButton() {
        return this.mouseButton;
    }

    public int getMouseWheel() {
        return this.mouseWheel;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public char getTypedChar() {
        return this.typedChar;
    }

    public float getPartialTicks() {
        return this.partialTicks;
    }

    public int getCurrentDrawingZ() {
        return this.currentDrawingZ;
    }

    public boolean isMuiContext() {
        return false;
    }

    public ModularGuiContext getMuiContext() {
        throw new UnsupportedOperationException("This is not a MuiContext");
    }
}

