/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.theme;

import com.cleanroommc.modularui.ModularUIConfig;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.IThemeApi;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.theme.AbstractDefaultTheme;
import com.cleanroommc.modularui.theme.ThemeManager;
import com.cleanroommc.modularui.theme.WidgetSlotTheme;
import com.cleanroommc.modularui.theme.WidgetTextFieldTheme;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.theme.WidgetThemeParser;
import com.cleanroommc.modularui.theme.WidgetThemeSelectable;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.JsonBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeAPI
implements IThemeApi {
    public static final ThemeAPI INSTANCE = new ThemeAPI();
    public static final String DEFAULT = "DEFAULT";
    public static final ITheme DEFAULT_DEFAULT = new DefaultTheme();
    private final Object2ObjectMap<String, ITheme> themes = new Object2ObjectOpenHashMap();
    protected final Object2ObjectMap<String, List<JsonBuilder>> defaultThemes = new Object2ObjectOpenHashMap();
    protected final Object2ObjectMap<String, WidgetTheme> defaultWidgetThemes = new Object2ObjectOpenHashMap();
    protected final Object2ObjectMap<String, WidgetThemeParser> widgetThemeFunctions = new Object2ObjectOpenHashMap();
    protected final Object2ObjectOpenHashMap<String, String> jsonScreenThemes = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, String> screenThemes = new Object2ObjectOpenHashMap();

    private ThemeAPI() {
        this.registerWidgetTheme("panel", new WidgetTheme(GuiTextures.MC_BACKGROUND, null, Color.WHITE.main, -12566464, false), WidgetTheme::new);
        this.registerWidgetTheme("button", new WidgetTheme(GuiTextures.MC_BUTTON, GuiTextures.MC_BUTTON_HOVERED, Color.WHITE.main, Color.WHITE.main, true), WidgetTheme::new);
        this.registerWidgetTheme("itemSlot", new WidgetSlotTheme((IDrawable)GuiTextures.SLOT_ITEM, Color.withAlpha(Color.WHITE.main, 96), false, GuiTextures.SLOT_ITEM_PLAYER, GuiTextures.SLOT_ITEM_HOTBAR), WidgetSlotTheme::new);
        this.registerWidgetTheme("fluidSlot", new WidgetSlotTheme((IDrawable)GuiTextures.SLOT_FLUID, Color.withAlpha(Color.WHITE.main, 96), false, null, null), WidgetSlotTheme::new);
        this.registerWidgetTheme("textField", new WidgetTextFieldTheme(-13667672, -10526881), (parent, json, fallback) -> new WidgetTextFieldTheme(parent, fallback, json));
        this.registerWidgetTheme("toggleButton", new WidgetThemeSelectable(GuiTextures.MC_BUTTON, GuiTextures.MC_BUTTON_HOVERED, Color.WHITE.main, Color.WHITE.main, true, GuiTextures.MC_BUTTON_DISABLED, IDrawable.NONE, Color.WHITE.main, Color.WHITE.main, true), WidgetThemeSelectable::new);
    }

    @Override
    public ITheme getDefaultTheme() {
        return DEFAULT_DEFAULT;
    }

    @Override
    @NotNull
    public ITheme getTheme(String id) {
        return (ITheme)this.themes.getOrDefault((Object)id, (Object)this.getDefaultTheme());
    }

    @Override
    public boolean hasTheme(String id) {
        return this.themes.containsKey((Object)id);
    }

    @Override
    public boolean hasWidgetTheme(String id) {
        return this.widgetThemeFunctions.containsKey((Object)id);
    }

    @Override
    public void registerTheme(String id, JsonBuilder json) {
        List<JsonBuilder> themes = this.getJavaDefaultThemes(id);
        if (!themes.contains(json)) {
            themes.add(json);
        }
    }

    @Override
    public List<JsonBuilder> getJavaDefaultThemes(String id) {
        return (List)this.defaultThemes.computeIfAbsent((Object)id, key -> new ArrayList());
    }

    @Override
    public ITheme getThemeForScreen(String owner, String name, @Nullable String defaultTheme) {
        String theme = this.getThemeIdForScreen(owner, name);
        if (theme != null) {
            return this.getTheme(theme);
        }
        if (defaultTheme != null) {
            return this.getTheme(defaultTheme);
        }
        return this.getTheme(ModularUIConfig.useDarkThemeByDefault ? "vanilla_dark" : "vanilla");
    }

    private String getThemeIdForScreen(String mod, String name) {
        String fullName = mod + ":" + name;
        String theme = (String)this.jsonScreenThemes.get((Object)fullName);
        if (theme != null) {
            return theme;
        }
        theme = (String)this.jsonScreenThemes.get((Object)mod);
        if (theme != null) {
            return theme;
        }
        theme = (String)this.screenThemes.get((Object)fullName);
        return theme != null ? theme : (String)this.screenThemes.get((Object)mod);
    }

    @Override
    public void registerThemeForScreen(String screen, String theme) {
        Objects.requireNonNull(screen);
        Objects.requireNonNull(theme);
        this.screenThemes.put((Object)screen, (Object)theme);
    }

    @Override
    public void registerWidgetTheme(String id, WidgetTheme defaultTheme, WidgetThemeParser parser) {
        if (this.widgetThemeFunctions.containsKey((Object)id)) {
            throw new IllegalStateException();
        }
        this.widgetThemeFunctions.put((Object)id, (Object)parser);
        this.defaultWidgetThemes.put((Object)id, (Object)defaultTheme);
    }

    void registerTheme(ITheme theme) {
        if (this.themes.containsKey((Object)theme.getId())) {
            throw new IllegalArgumentException("Theme with id " + theme.getId() + " already exists!");
        }
        this.themes.put((Object)theme.getId(), (Object)theme);
    }

    void onReload() {
        this.themes.clear();
        this.jsonScreenThemes.clear();
        this.registerTheme(DEFAULT_DEFAULT);
    }

    public static class DefaultTheme
    extends AbstractDefaultTheme {
        private DefaultTheme() {
        }

        @Override
        public String getId() {
            return ThemeAPI.DEFAULT;
        }

        @Override
        public WidgetTheme getFallback() {
            return ThemeManager.defaultdefaultWidgetTheme;
        }

        @Override
        public WidgetTheme getWidgetTheme(String id) {
            return (WidgetTheme)ThemeAPI.INSTANCE.defaultWidgetThemes.get((Object)id);
        }
    }
}

