/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.utils.serialization.IByteBufAdapter;
import com.cleanroommc.modularui.utils.serialization.IByteBufDeserializer;
import com.cleanroommc.modularui.utils.serialization.IByteBufSerializer;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.network.PacketBuffer;

public interface ICopy<T> {
    public static <T> ICopy<T> immutable() {
        return t -> t;
    }

    public static <T> ICopy<T> ofSerializer(IByteBufSerializer<T> serializer, IByteBufDeserializer<T> deserializer) {
        return t -> {
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            try {
                serializer.serialize(buffer, t);
                return deserializer.deserialize(buffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T> ICopy<T> ofSerializer(IByteBufAdapter<T> adapter) {
        return ICopy.ofSerializer(adapter, adapter);
    }

    public T createDeepCopy(T var1);
}

