/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.Constant;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.Expression;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.PrimitiveElement;
import com.cleanroommc.modularui.utils.ParseResult;

public class MathUtils {
    public static final Constant k = new Constant("k", 1000.0);
    public static final Constant M = new Constant("M", 1000000.0);
    public static final Constant G = new Constant("G", 1.0E9);
    public static final Constant T = new Constant("T", 1.0E12);
    public static final Constant P = new Constant("P", 1.0E15);
    public static final Constant E = new Constant("E", 1.0E18);
    public static final Constant Z = new Constant("Z", 1.0E21);
    public static final Constant Y = new Constant("Y", 1.0E24);
    public static final Constant m = new Constant("m", 0.001);
    public static final Constant u = new Constant("u", 1.0E-6);
    public static final Constant n = new Constant("n", 1.0E-9);
    public static final Constant p = new Constant("p", 1.0E-12);
    public static final Constant f = new Constant("f", 1.0E-15);
    public static final Constant a = new Constant("a", 1.0E-18);
    public static final Constant z = new Constant("z", 1.0E-21);
    public static final Constant y = new Constant("y", 1.0E-24);

    public static ParseResult parseExpression(String expression) {
        return MathUtils.parseExpression(expression, Double.NaN, false);
    }

    public static ParseResult parseExpression(String expression, boolean useSiPrefixes) {
        return MathUtils.parseExpression(expression, Double.NaN, useSiPrefixes);
    }

    public static ParseResult parseExpression(String expression, double defaultValue) {
        return MathUtils.parseExpression(expression, defaultValue, true);
    }

    public static ParseResult parseExpression(String expression, double defaultValue, boolean useSiPrefixes) {
        double result;
        if (expression == null || expression.isEmpty()) {
            return ParseResult.success(defaultValue);
        }
        Expression e = new Expression(expression, new PrimitiveElement[0]);
        if (useSiPrefixes) {
            e.addConstants(k, M, G, T, P, E, Z, Y, m, u, n, p, f, a, z, y);
        }
        if (Double.isNaN(result = e.calculate())) {
            return ParseResult.failure(defaultValue, e.getErrorMessage());
        }
        return ParseResult.success(result);
    }

    public static int clamp(int v, int min, int max) {
        return Math.max(min, Math.min(v, max));
    }

    public static float clamp(float v, float min, float max) {
        return Math.max(min, Math.min(v, max));
    }

    public static double clamp(double v, double min, double max) {
        return Math.max(min, Math.min(v, max));
    }

    public static long clamp(long v, long min, long max) {
        return Math.max(min, Math.min(v, max));
    }

    public static int cycler(int x, int min, int max) {
        return x < min ? max : (x > max ? min : x);
    }

    public static float cycler(float x, float min, float max) {
        return x < min ? max : (x > max ? min : x);
    }

    public static double cycler(double x, double min, double max) {
        return x < min ? max : (x > max ? min : x);
    }

    public static int gridIndex(int x, int y, int size, int width) {
        return (x /= size) + (y /= size) * width / size;
    }

    public static int gridRows(int count, int size, int width) {
        double x = (double)(count * size) / (double)width;
        return count <= 0 ? 1 : (int)Math.ceil(x);
    }

    public static int min(int ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException();
        }
        if (values.length == 1) {
            return values[0];
        }
        if (values.length == 2) {
            return Math.min(values[0], values[1]);
        }
        int min = Integer.MAX_VALUE;
        for (int i : values) {
            if (i >= min) continue;
            min = i;
        }
        return min;
    }

    public static int max(int ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException();
        }
        if (values.length == 1) {
            return values[0];
        }
        if (values.length == 2) {
            return Math.max(values[0], values[1]);
        }
        int max = Integer.MIN_VALUE;
        for (int i : values) {
            if (i <= max) continue;
            max = i;
        }
        return max;
    }
}

