/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.utils.fakeworld.BlockInfo;
import com.cleanroommc.modularui.utils.fakeworld.BlockPosUtil;
import com.cleanroommc.modularui.utils.fakeworld.DummyWorld;
import com.cleanroommc.modularui.utils.fakeworld.ISchema;
import com.google.common.collect.AbstractIterator;
import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import cpw.mods.fml.common.registry.GameRegistry;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class ArraySchema
implements ISchema {
    private static final BlockPos ORIGIN = new BlockPos(0, 0, 0);
    private final World world;
    private final BlockInfo[][][] blocks;
    private BiPredicate<BlockPos, BlockInfo> renderFilter;
    private final Vector3d center;

    public static Builder builder() {
        return new Builder();
    }

    public ArraySchema(BlockInfo[][][] blocks) {
        this.blocks = blocks;
        this.world = new DummyWorld();
        BlockPos current = new BlockPos();
        BlockPos max = new BlockPos(BlockPosUtil.MIN.x, BlockPosUtil.MIN.y, BlockPosUtil.MAX.z);
        for (int x = 0; x < blocks.length; ++x) {
            for (int y = 0; y < blocks[x].length; ++y) {
                for (int z = 0; z < blocks[x][y].length; ++z) {
                    BlockInfo block = blocks[x][y][z];
                    if (block == null) continue;
                    current.set(x, y, z);
                    BlockPosUtil.setMax(max, current);
                    block.apply(this.world, current);
                }
            }
        }
        this.center = BlockPosUtil.getCenterD(ORIGIN, BlockPosUtil.add(max, 1, 1, 1));
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Vector3d getFocus() {
        return this.center;
    }

    @Override
    public BlockPos getOrigin() {
        return ORIGIN;
    }

    @Override
    public void setRenderFilter(@Nullable BiPredicate<BlockPos, BlockInfo> renderFilter) {
        this.renderFilter = renderFilter;
    }

    @Override
    @Nullable
    public BiPredicate<BlockPos, BlockInfo> getRenderFilter() {
        return this.renderFilter;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<BlockPos, BlockInfo>> iterator() {
        return new AbstractIterator<Map.Entry<BlockPos, BlockInfo>>(){
            private final BlockPos pos = new BlockPos();
            private final MutablePair<BlockPos, BlockInfo> pair = new MutablePair((Object)this.pos, null);
            private int x = 0;
            private int y = 0;
            private int z = -1;

            protected Map.Entry<BlockPos, BlockInfo> computeNext() {
                BlockInfo info;
                do {
                    if (++this.z >= ArraySchema.this.blocks[this.x][this.y].length) {
                        this.z = 0;
                        if (++this.y >= ArraySchema.this.blocks[this.x].length) {
                            this.y = 0;
                            if (++this.x >= ArraySchema.this.blocks.length) {
                                return (Map.Entry)this.endOfData();
                            }
                        }
                    }
                    this.pos.set(this.x, this.y, this.z);
                } while ((info = ArraySchema.this.blocks[this.x][this.y][this.z]) == null || !ArraySchema.this.renderFilter.test(this.pos, info));
                this.pair.setRight((Object)info);
                return this.pair;
            }
        };
    }

    public static class Builder {
        private final List<String[]> tensor = new ArrayList<String[]>();
        private final Char2ObjectMap<BlockInfo> blockMap = new Char2ObjectOpenHashMap();

        public Builder() {
            this.blockMap.put(' ', (Object)BlockInfo.EMPTY);
            this.blockMap.put('#', (Object)BlockInfo.EMPTY);
        }

        public Builder layer(String ... layer) {
            this.tensor.add(layer);
            return this;
        }

        public Builder where(char c, BlockInfo info) {
            this.blockMap.put(c, (Object)info);
            return this;
        }

        public Builder whereAir(char c) {
            return this.where(c, BlockInfo.EMPTY);
        }

        public Builder where(char c, Block block) {
            return this.where(c, new BlockInfo(block));
        }

        public Builder where(char c, Block block, int blockMeta) {
            return this.where(c, new BlockInfo(block, blockMeta));
        }

        public Builder where(char c, Block block, TileEntity tile) {
            return this.where(c, new BlockInfo(block, tile));
        }

        public Builder where(char c, Block block, int blockMeta, TileEntity tile) {
            return this.where(c, new BlockInfo(block, blockMeta, tile));
        }

        public Builder where(char c, ResourceLocation registryName, int stateMeta) {
            Block block = GameRegistry.findBlock((String)registryName.func_110624_b(), (String)registryName.func_110623_a());
            if (block == null) {
                throw new IllegalArgumentException("Block with name " + registryName + " doesn't exist!");
            }
            return this.where(c, new BlockInfo(block, stateMeta));
        }

        public Builder where(char c, ResourceLocation registryName) {
            return this.where(c, registryName, 0);
        }

        public Builder where(char c, String registryName, int stateMeta) {
            return this.where(c, new ResourceLocation(registryName), stateMeta);
        }

        public Builder where(char c, String registryName) {
            return this.where(c, new ResourceLocation(registryName), 0);
        }

        private void validate() {
            if (this.tensor.isEmpty()) {
                throw new IllegalArgumentException("no block matrix defined");
            }
            ArrayList<String> errors = new ArrayList<String>();
            CharArraySet checkedChars = new CharArraySet();
            int layerSize = this.tensor.get(0).length;
            for (int x = 0; x < this.tensor.size(); ++x) {
                String[] xLayer = this.tensor.get(x);
                if (xLayer.length == 0) {
                    errors.add(String.format("Layer %s is empty. This is not right", x + 1));
                } else if (xLayer.length != layerSize) {
                    errors.add(String.format("Invalid x-layer size. Expected %s, but got %s at layer %s", layerSize, xLayer.length, x + 1));
                }
                int rowSize = xLayer[0].length();
                for (int y = 0; y < xLayer.length; ++y) {
                    String yRow = xLayer[y];
                    if (yRow.isEmpty()) {
                        errors.add(String.format("Row %s in layer %s is empty. This is not right", y + 1, x + 1));
                    } else if (yRow.length() != rowSize) {
                        errors.add(String.format("Invalid x-layer size. Expected %s, but got %s at row %s in layer %s", layerSize, xLayer.length, y + 1, x + 1));
                    }
                    for (int z = 0; z < yRow.length(); ++z) {
                        char zChar = yRow.charAt(z);
                        if (checkedChars.contains(zChar)) continue;
                        if (!this.blockMap.containsKey(zChar)) {
                            errors.add(String.format("Found char '%s' at char %s in row %s in layer %s, but character was not found in map!", Character.valueOf(zChar), z + 1, y + 1, x + 1));
                        }
                        checkedChars.add(zChar);
                    }
                }
            }
            if (!errors.isEmpty()) {
                ModularUI.LOGGER.error("Error validating ArrayScheme BlockArray:");
                for (String e : errors) {
                    ModularUI.LOGGER.error("  - {}", new Object[]{e});
                }
                throw new IllegalArgumentException("The ArraySchema builder was misconfigured. See message above.");
            }
        }

        public ArraySchema build() {
            this.validate();
            BlockInfo[][][] blocks = new BlockInfo[this.tensor.size()][this.tensor.get(0).length][this.tensor.get(0)[0].length()];
            for (int x = 0; x < this.tensor.size(); ++x) {
                String[] xLayer = this.tensor.get(x);
                for (int y = 0; y < xLayer.length; ++y) {
                    String yRow = xLayer[y];
                    for (int z = 0; z < yRow.length(); ++z) {
                        char zChar = yRow.charAt(z);
                        BlockInfo info = (BlockInfo)this.blockMap.get(zChar);
                        if (info == null || info == BlockInfo.EMPTY) continue;
                        blocks[x][y][z] = info;
                    }
                }
            }
            return new ArraySchema(blocks);
        }
    }
}

