/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget;

import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.layout.IViewportStack;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.Stencil;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.utils.HoveredWidgetList;
import com.cleanroommc.modularui.widget.AbstractParentWidget;
import com.cleanroommc.modularui.widget.scroll.HorizontalScrollData;
import com.cleanroommc.modularui.widget.scroll.ScrollArea;
import com.cleanroommc.modularui.widget.scroll.VerticalScrollData;
import com.cleanroommc.modularui.widget.sizer.Area;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScrollWidget<I extends IWidget, W extends AbstractScrollWidget<I, W>>
extends AbstractParentWidget<I, W>
implements IViewport,
Interactable {
    private final ScrollArea scroll = new ScrollArea();
    private boolean keepScrollBarInArea = false;

    public AbstractScrollWidget(@Nullable HorizontalScrollData x, @Nullable VerticalScrollData y) {
        this.scroll.setScrollDataX(x);
        this.scroll.setScrollDataY(y);
        this.listenGuiAction(mouseButton -> {
            this.scroll.mouseReleased(this.getContext());
            return false;
        });
    }

    @Override
    public Area getArea() {
        return this.scroll;
    }

    public ScrollArea getScrollArea() {
        return this.scroll;
    }

    @Override
    public void transformChildren(IViewportStack stack) {
        stack.translate(-this.getScrollX(), -this.getScrollY());
    }

    @Override
    public void getSelfAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (this.isInside(stack, x, y)) {
            widgets.add(this, stack.peek());
        }
    }

    @Override
    public void getWidgetsAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (this.getArea().isInside(x, y) && !this.getScrollArea().isInsideScrollbarArea(x, y) && this.hasChildren()) {
            IViewport.getChildrenAt(this, stack, widgets, x, y);
        }
    }

    @Override
    public void onResized() {
        super.onResized();
        if (this.scroll.getScrollX() != null) {
            this.scroll.getScrollX().clamp(this.scroll);
            if (!this.keepScrollBarInArea) {
                this.getArea().height += this.scroll.getScrollX().getThickness();
            }
        }
        if (this.scroll.getScrollY() != null) {
            this.scroll.getScrollY().clamp(this.scroll);
            if (!this.keepScrollBarInArea) {
                this.getArea().width += this.scroll.getScrollY().getThickness();
            }
        }
    }

    @Override
    public boolean canHover() {
        return super.canHover() || this.scroll.isInsideScrollbarArea(this.getContext().getMouseX(), this.getContext().getMouseY());
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(int mouseButton) {
        ModularGuiContext context = this.getContext();
        if (this.scroll.mouseClicked(context)) {
            return Interactable.Result.STOP;
        }
        return Interactable.Result.IGNORE;
    }

    @Override
    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        return this.scroll.mouseScroll(this.getContext());
    }

    @Override
    public boolean onMouseRelease(int mouseButton) {
        this.scroll.mouseReleased(this.getContext());
        return false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.scroll.drag(this.getContext().getAbsMouseX(), this.getContext().getAbsMouseY());
    }

    @Override
    public void preDraw(ModularGuiContext context, boolean transformed) {
        if (!transformed) {
            Stencil.applyAtZero(this.scroll, context);
        }
    }

    @Override
    public void postDraw(ModularGuiContext context, boolean transformed) {
        if (!transformed) {
            Stencil.remove();
            this.scroll.drawScrollbar();
        }
    }

    public int getScrollX() {
        return this.scroll.getScrollX() != null ? this.scroll.getScrollX().getScroll() : 0;
    }

    public int getScrollY() {
        return this.scroll.getScrollY() != null ? this.scroll.getScrollY().getScroll() : 0;
    }

    public W keepScrollBarInArea(boolean value) {
        this.keepScrollBarInArea = value;
        return (W)((AbstractScrollWidget)this.getThis());
    }

    public W keepScrollBarInArea() {
        return this.keepScrollBarInArea(true);
    }
}

