/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.GuiListBiomesEntry;
import com.chaosthedude.naturescompass.gui.GuiNaturesCompass;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.world.biome.BiomeGenBase;

@SideOnly(value=Side.CLIENT)
public class GuiListBiomes
extends GuiListExtended {
    private final GuiNaturesCompass guiNaturesCompass;
    private final List<GuiListBiomesEntry> entries = Lists.newArrayList();
    private int selectedIndex = -1;

    public GuiListBiomes(GuiNaturesCompass guiNaturesCompass, Minecraft mc, int width, int height, int top, int bottom, int slotHeight) {
        super(mc, width, height, top, bottom, slotHeight);
        this.guiNaturesCompass = guiNaturesCompass;
        this.refreshList();
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 20;
    }

    public int func_148139_c() {
        return super.func_148139_c() + 50;
    }

    protected boolean func_148131_a(int slotIndex) {
        return slotIndex == this.selectedIndex;
    }

    public GuiListBiomesEntry getListEntry(int index) {
        return this.entries.get(index);
    }

    protected int func_148127_b() {
        return this.entries.size();
    }

    @Nullable
    public GuiListBiomesEntry getSelectedBiome() {
        return this.selectedIndex >= 0 && this.selectedIndex < this.func_148127_b() ? this.getListEntry(this.selectedIndex) : null;
    }

    public void refreshList() {
        this.entries.clear();
        for (BiomeGenBase biome : this.guiNaturesCompass.sortBiomes()) {
            this.entries.add(new GuiListBiomesEntry(this, biome));
        }
    }

    public void selectBiome(int index) {
        this.selectedIndex = index;
        this.guiNaturesCompass.selectBiome(this.getSelectedBiome());
    }

    public GuiNaturesCompass getGuiNaturesCompass() {
        return this.guiNaturesCompass;
    }
}

