/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.neid.asm;

import com.gtnewhorizons.neid.asm.AsmTransformException;
import com.gtnewhorizons.neid.asm.ClassNodeTransformers;
import com.gtnewhorizons.neid.core.NEIDCore;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class NEIDTransformer
implements IClassTransformer {
    private static final boolean DUMP_CLASSES = Boolean.parseBoolean(System.getProperty("neid.dumpClass", "false"));
    private static final Logger logger = LogManager.getLogger((String)"NEID");
    private File outputDir = null;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassNodeTransformers transformer = ClassNodeTransformers.get(transformedName);
        if (transformer == null) {
            return bytes;
        }
        logger.debug("Patching {} with {}...", new Object[]{transformedName, transformer.getName()});
        ClassNode cn = new ClassNode(327680);
        ClassReader cr = new ClassReader(bytes);
        cr.accept((ClassVisitor)cn, 0);
        try {
            transformer.transform(cn, NEIDCore.isObfuscated());
        }
        catch (AsmTransformException t) {
            logger.error("Error transforming {} with {}: {}", new Object[]{transformedName, transformer.getName(), t.getMessage()});
            throw t;
        }
        catch (Throwable t2) {
            logger.error("Error transforming {} with {}: {}", new Object[]{transformedName, transformer.getName(), t2.getMessage()});
            throw new RuntimeException(t2);
        }
        ClassWriter cw = new ClassWriter(0);
        cn.accept((ClassVisitor)cw);
        byte[] transformedBytes = cw.toByteArray();
        logger.debug("Patched {} successfully.", new Object[]{transformer.getName()});
        this.saveTransformedClass(transformedBytes, transformedName);
        return transformedBytes;
    }

    private void saveTransformedClass(byte[] data, String transformedName) {
        String fileName;
        File classFile;
        File outDir;
        if (!DUMP_CLASSES) {
            return;
        }
        if (this.outputDir == null) {
            this.outputDir = new File(Launch.minecraftHome, "ASM_NEID");
            try {
                FileUtils.deleteDirectory((File)this.outputDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!this.outputDir.exists()) {
                this.outputDir.mkdirs();
            }
        }
        if (!(outDir = (classFile = new File(this.outputDir, (fileName = transformedName.replace('.', File.separatorChar)) + ".class")).getParentFile()).exists()) {
            outDir.mkdirs();
        }
        if (classFile.exists()) {
            classFile.delete();
        }
        try (OutputStream output = Files.newOutputStream(classFile.toPath(), new OpenOption[0]);){
            output.write(data);
        }
        catch (IOException e) {
            logger.error("Could not save transformed class (byte[]) " + transformedName, (Throwable)e);
        }
    }
}

