/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.client.renderer;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import pcl.opensecurity.ContentRegistry;
import pcl.opensecurity.tileentity.TileEntityKeypadLock;

public class RenderKeypad
extends TileEntitySpecialRenderer
implements IItemRenderer {
    static float texPixel = 0.0625f;
    static TileEntityKeypadLock.ButtonState[] itemButtonStates;
    static String[] default_labels;
    static byte[] default_colors;
    static ButtonPosition[] buttons;
    static ButtonPosition display;

    public static void renderButtonGeometry(Tessellator tessellator, float depth, ButtonPosition pos) {
        float tx = texPixel * 2.0f;
        float ty = texPixel * 2.0f;
        float x = pos.x * texPixel;
        float y = pos.y * texPixel;
        float z = depth;
        float w = pos.w * texPixel;
        float h = pos.h * texPixel;
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        tessellator.func_78374_a((double)x, (double)y, (double)z, (double)tx, (double)ty);
        tessellator.func_78374_a((double)x, (double)(y + h), (double)z, (double)tx, (double)(ty + 2.0f * texPixel));
        tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)z, (double)(tx + 2.0f * texPixel), (double)(ty + 2.0f * texPixel));
        tessellator.func_78374_a((double)(x + w), (double)y, (double)z, (double)(tx + 2.0f * texPixel), (double)ty);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        tessellator.func_78374_a((double)x, (double)y, (double)z, (double)tx, (double)ty);
        tessellator.func_78374_a((double)x, (double)y, (double)(z + 1.0f), (double)(tx + 2.0f * texPixel), (double)ty);
        tessellator.func_78374_a((double)x, (double)(y + h), (double)(z + 1.0f), (double)(tx + 2.0f * texPixel), (double)(ty + 2.0f * texPixel));
        tessellator.func_78374_a((double)x, (double)(y + h), (double)z, (double)tx, (double)(ty + 2.0f * texPixel));
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        tessellator.func_78374_a((double)(x + w), (double)y, (double)(z + 1.0f), (double)(tx + 2.0f * texPixel), (double)ty);
        tessellator.func_78374_a((double)(x + w), (double)y, (double)z, (double)tx, (double)ty);
        tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)z, (double)tx, (double)(ty + 2.0f * texPixel));
        tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)(z + 1.0f), (double)(tx + 2.0f * texPixel), (double)(ty + 2.0f * texPixel));
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        tessellator.func_78374_a((double)x, (double)y, (double)z, (double)tx, (double)ty);
        tessellator.func_78374_a((double)(x + w), (double)y, (double)z, (double)(tx + 2.0f * texPixel), (double)ty);
        tessellator.func_78374_a((double)(x + w), (double)y, (double)(z + 1.0f), (double)(tx + 2.0f * texPixel), (double)(ty + 2.0f * texPixel));
        tessellator.func_78374_a((double)x, (double)y, (double)(z + 1.0f), (double)tx, (double)(ty + 2.0f * texPixel));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        tessellator.func_78374_a((double)x, (double)(y + h), (double)(z + 1.0f), (double)(tx + 2.0f * texPixel), (double)ty);
        tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)(z + 1.0f), (double)(tx + 2.0f * texPixel), (double)(ty + 2.0f * texPixel));
        tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)z, (double)tx, (double)(ty + 2.0f * texPixel));
        tessellator.func_78374_a((double)x, (double)(y + h), (double)z, (double)tx, (double)ty);
    }

    public static void writeButtonLabel(FontRenderer font, float depth, ButtonPosition pos, int color, String label) {
        float x = pos.x * texPixel;
        float y = pos.y * texPixel;
        float w = pos.w * texPixel;
        float h = pos.h * texPixel;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)(x + w / 2.0f), (float)(y + h / 2.0f), (float)(depth + texPixel * -0.07f));
        int labelW = font.func_78256_a(label);
        float scale = Math.min(h / 10.0f, 0.8f * w / (float)labelW);
        GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
        GL11.glDepthMask((boolean)false);
        int argb = -16777216;
        if ((color & 4) != 0) {
            argb |= 0xFF0000;
        }
        if ((color & 2) != 0) {
            argb |= 0xFF00;
        }
        if ((color & 1) != 0) {
            argb |= 0xFF;
        }
        font.func_78276_b(label, -labelW / 2, -4, argb);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f) {
        TileEntityKeypadLock te = (TileEntityKeypadLock)tileEntity;
        Tessellator tessellator = Tessellator.field_78398_a;
        int bx = te.field_145851_c;
        int by = te.field_145848_d;
        int bz = te.field_145849_e;
        World world = te.func_145831_w();
        float brightness = ContentRegistry.keypadLockBlock.getLightValue((IBlockAccess)world, bx, by, bz);
        int light = world.func_72802_i(bx, by, bz, 0);
        tessellator.func_78386_a(brightness, brightness, brightness);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(light & 0xFFFF), (float)(light >> 16));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        GL11.glRotatef((float)te.getAngle(), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        long time = world.func_82737_E();
        this.func_147499_a(new ResourceLocation("opensecurity", "textures/blocks/machine_side.png"));
        this.drawKeypadBlock(te, time);
        GL11.glPopMatrix();
    }

    public void drawKeypadBlock(TileEntityKeypadLock keylock, long time) {
        int i;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        tessellator.func_78374_a((double)texPixel, (double)texPixel, (double)texPixel, (double)texPixel, (double)(1.0f - texPixel));
        tessellator.func_78374_a((double)texPixel, (double)(1.0f - texPixel), (double)texPixel, (double)texPixel, (double)texPixel);
        tessellator.func_78374_a((double)(1.0f - texPixel), (double)(1.0f - texPixel), (double)texPixel, (double)(1.0f - texPixel), (double)texPixel);
        tessellator.func_78374_a((double)(1.0f - texPixel), (double)texPixel, (double)texPixel, (double)(1.0f - texPixel), (double)(1.0f - texPixel));
        tessellator.func_78374_a(0.0, 0.0, (double)0.001f, 0.0, 0.0);
        tessellator.func_78374_a((double)texPixel, (double)texPixel, (double)0.001f, (double)texPixel, (double)texPixel);
        tessellator.func_78374_a((double)(1.0f - texPixel), (double)texPixel, (double)0.001f, (double)(1.0f - texPixel), (double)texPixel);
        tessellator.func_78374_a(1.0, 0.0, (double)0.001f, 1.0, 0.0);
        tessellator.func_78374_a((double)texPixel, (double)(1.0f - texPixel), (double)0.001f, (double)texPixel, (double)(1.0f - texPixel));
        tessellator.func_78374_a(0.0, 1.0, (double)0.001f, 0.0, 1.0);
        tessellator.func_78374_a(1.0, 1.0, (double)0.001f, 1.0, 1.0);
        tessellator.func_78374_a((double)(1.0f - texPixel), (double)(1.0f - texPixel), (double)0.001f, (double)(1.0f - texPixel), (double)(1.0f - texPixel));
        tessellator.func_78374_a(0.0, 0.0, (double)0.001f, 0.0, 0.0);
        tessellator.func_78374_a(0.0, 1.0, (double)0.001f, 0.0, 1.0);
        tessellator.func_78374_a((double)texPixel, (double)(1.0f - texPixel), (double)0.001f, (double)texPixel, (double)(1.0f - texPixel));
        tessellator.func_78374_a((double)texPixel, (double)texPixel, (double)0.001f, (double)texPixel, (double)texPixel);
        tessellator.func_78374_a((double)(1.0f - texPixel), (double)texPixel, (double)0.001f, (double)(1.0f - texPixel), (double)texPixel);
        tessellator.func_78374_a((double)(1.0f - texPixel), (double)(1.0f - texPixel), (double)0.001f, (double)(1.0f - texPixel), (double)(1.0f - texPixel));
        tessellator.func_78374_a(1.0, 1.0, (double)0.001f, 1.0, 1.0);
        tessellator.func_78374_a(1.0, 0.0, (double)0.001f, 1.0, 0.0);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        tessellator.func_78374_a((double)texPixel, (double)texPixel, 0.0, (double)texPixel, 1.0);
        tessellator.func_78374_a((double)texPixel, (double)texPixel, (double)texPixel, (double)texPixel, (double)(1.0f - texPixel));
        tessellator.func_78374_a((double)(1.0f - texPixel), (double)texPixel, (double)texPixel, (double)(1.0f - texPixel), (double)(1.0f - texPixel));
        tessellator.func_78374_a((double)(1.0f - texPixel), (double)texPixel, 0.0, (double)(1.0f - texPixel), 1.0);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        tessellator.func_78374_a((double)texPixel, (double)(1.0f - texPixel), (double)texPixel, (double)texPixel, (double)texPixel);
        tessellator.func_78374_a((double)texPixel, (double)(1.0f - texPixel), 0.0, (double)texPixel, 0.0);
        tessellator.func_78374_a((double)(1.0f - texPixel), (double)(1.0f - texPixel), 0.0, (double)(1.0f - texPixel), 0.0);
        tessellator.func_78374_a((double)(1.0f - texPixel), (double)(1.0f - texPixel), (double)texPixel, (double)(1.0f - texPixel), (double)texPixel);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        tessellator.func_78374_a((double)texPixel, (double)texPixel, 0.0, (double)(1.0f - texPixel), (double)texPixel);
        tessellator.func_78374_a((double)texPixel, (double)(1.0f - texPixel), 0.0, (double)(1.0f - texPixel), (double)(1.0f - texPixel));
        tessellator.func_78374_a((double)texPixel, (double)(1.0f - texPixel), (double)texPixel, 1.0, (double)(1.0f - texPixel));
        tessellator.func_78374_a((double)texPixel, (double)texPixel, (double)texPixel, 1.0, (double)texPixel);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        tessellator.func_78374_a((double)(1.0f - texPixel), (double)texPixel, (double)texPixel, 1.0, (double)texPixel);
        tessellator.func_78374_a((double)(1.0f - texPixel), (double)(1.0f - texPixel), (double)texPixel, 1.0, (double)(1.0f - texPixel));
        tessellator.func_78374_a((double)(1.0f - texPixel), (double)(1.0f - texPixel), 0.0, (double)(1.0f - texPixel), (double)(1.0f - texPixel));
        tessellator.func_78374_a((double)(1.0f - texPixel), (double)texPixel, 0.0, (double)(1.0f - texPixel), (double)texPixel);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78380_c(255);
        boolean[] pressed = new boolean[12];
        for (i = 0; i < pressed.length; ++i) {
            pressed[i] = keylock != null ? keylock.buttonStates[i].isPressed(time) : false;
        }
        for (i = 0; i < 12; ++i) {
            RenderKeypad.renderButtonGeometry(tessellator, pressed[i] ? texPixel * 0.75f : 0.0f, buttons[i]);
        }
        RenderKeypad.renderButtonGeometry(tessellator, 0.0f, display);
        tessellator.func_78381_a();
        FontRenderer font = this.func_147498_b();
        if (font != null) {
            String[] btnLabels = keylock != null ? keylock.buttonLabels : default_labels;
            byte[] btnColors = keylock != null ? keylock.buttonColors : default_colors;
            String fbText = keylock != null ? keylock.displayText : "";
            int fbColor = keylock != null ? (int)keylock.displayColor : 7;
            for (int i2 = 0; i2 < 12; ++i2) {
                String lbl = btnLabels[i2];
                if (lbl == null) {
                    lbl = default_labels[i2];
                }
                if (lbl.length() <= 0) continue;
                RenderKeypad.writeButtonLabel(font, pressed[i2] ? texPixel * 0.75f : 0.0f, buttons[i2], btnColors[i2], lbl);
            }
            if (fbText != null && fbText.length() > 0) {
                RenderKeypad.writeButtonLabel(font, 0.0f, display, fbColor, fbText);
            }
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        } else if (type != IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        } else {
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        }
        this.func_147499_a(new ResourceLocation("opensecurity", "textures/blocks/machine_side.png"));
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)1.0f);
        if (type != IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glEnd();
            GL11.glBegin((int)7);
            GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glEnd();
        this.drawKeypadBlock(null, 10000L);
        GL11.glPopMatrix();
    }

    static {
        default_labels = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "0", "#"};
        default_colors = new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
        buttons = null;
        display = null;
        itemButtonStates = new TileEntityKeypadLock.ButtonState[12];
        for (int i = 0; i < 12; ++i) {
            RenderKeypad.itemButtonStates[i] = new TileEntityKeypadLock.ButtonState();
        }
        buttons = new ButtonPosition[12];
        RenderKeypad.buttons[0] = new ButtonPosition(10.0f, 9.5f, 2.0f, 2.0f);
        RenderKeypad.buttons[1] = new ButtonPosition(7.0f, 9.5f, 2.0f, 2.0f);
        RenderKeypad.buttons[2] = new ButtonPosition(4.0f, 9.5f, 2.0f, 2.0f);
        RenderKeypad.buttons[3] = new ButtonPosition(10.0f, 7.0f, 2.0f, 2.0f);
        RenderKeypad.buttons[4] = new ButtonPosition(7.0f, 7.0f, 2.0f, 2.0f);
        RenderKeypad.buttons[5] = new ButtonPosition(4.0f, 7.0f, 2.0f, 2.0f);
        RenderKeypad.buttons[6] = new ButtonPosition(10.0f, 4.5f, 2.0f, 2.0f);
        RenderKeypad.buttons[7] = new ButtonPosition(7.0f, 4.5f, 2.0f, 2.0f);
        RenderKeypad.buttons[8] = new ButtonPosition(4.0f, 4.5f, 2.0f, 2.0f);
        RenderKeypad.buttons[9] = new ButtonPosition(10.0f, 2.0f, 2.0f, 2.0f);
        RenderKeypad.buttons[10] = new ButtonPosition(7.0f, 2.0f, 2.0f, 2.0f);
        RenderKeypad.buttons[11] = new ButtonPosition(4.0f, 2.0f, 2.0f, 2.0f);
        display = new ButtonPosition(4.0f, 12.0f, 8.0f, 2.0f);
    }

    static class ButtonPosition {
        public float x;
        public float y;
        public float w;
        public float h;

        ButtonPosition(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

