/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Connector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.TileEntitySidedEnvironment;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySwitchableHub
extends TileEntitySidedEnvironment
implements SidedEnvironment,
Environment {
    protected Node node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create();
    public boolean north = false;
    public boolean south = false;
    public boolean east = false;
    public boolean west = false;
    public boolean up = false;
    public boolean down = false;
    public static ForgeDirection sideBack;
    public static ForgeDirection sideLeft;
    public static ForgeDirection sideRight;
    public static ForgeDirection sideFront;
    public static ForgeDirection sideUp;
    public static ForgeDirection sideDown;
    private String password = "";
    public int Texture;

    public TileEntitySwitchableHub() {
        super(new Node[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canConnect(ForgeDirection side) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (meta == side.ordinal()) {
            return true;
        }
        if (side.ordinal() == ForgeDirection.NORTH.ordinal() && this.north) {
            return true;
        }
        if (side.ordinal() == ForgeDirection.SOUTH.ordinal() && this.south) {
            return true;
        }
        if (side.ordinal() == ForgeDirection.EAST.ordinal() && this.east) {
            return true;
        }
        if (side.ordinal() == ForgeDirection.WEST.ordinal() && this.west) {
            return true;
        }
        if (side.ordinal() == ForgeDirection.UP.ordinal() && this.up) {
            return true;
        }
        return side.ordinal() == ForgeDirection.DOWN.ordinal() && this.down;
    }

    public String getComponentName() {
        return "os_switchinghub";
    }

    public Node sidedNode(ForgeDirection side) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (meta == side.ordinal()) {
            return this.node;
        }
        if (side.ordinal() == ForgeDirection.NORTH.ordinal() && this.north) {
            return this.node;
        }
        if (side.ordinal() == ForgeDirection.SOUTH.ordinal() && this.south) {
            return this.node;
        }
        if (side.ordinal() == ForgeDirection.EAST.ordinal() && this.east) {
            return this.node;
        }
        if (side.ordinal() == ForgeDirection.WEST.ordinal() && this.west) {
            return this.node;
        }
        if (side.ordinal() == ForgeDirection.UP.ordinal() && this.up) {
            return this.node;
        }
        if (side.ordinal() == ForgeDirection.DOWN.ordinal() && this.down) {
            return this.node;
        }
        return null;
    }

    public Node node() {
        return this.node;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void onConnect(Node node) {
    }

    public void onMessage(Message message) {
    }

    public void onDisconnect(Node node) {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.node != null && this.node.host() == this) {
            this.node.load(nbt.func_74775_l("oc:node"));
        }
        this.north = nbt.func_74767_n("north");
        this.south = nbt.func_74767_n("south");
        this.west = nbt.func_74767_n("west");
        this.east = nbt.func_74767_n("east");
        this.up = nbt.func_74767_n("up");
        this.down = nbt.func_74767_n("down");
        this.password = nbt.func_74779_i("password");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
        nbt.func_74757_a("north", this.north);
        nbt.func_74757_a("south", this.south);
        nbt.func_74757_a("east", this.east);
        nbt.func_74757_a("west", this.west);
        nbt.func_74757_a("up", this.up);
        nbt.func_74757_a("down", this.down);
        nbt.func_74778_a("password", this.password);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.node != null && this.node.network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    @Callback
    public Object[] greet(Context context, Arguments args) {
        return new Object[]{"Lasciate ogne speranza, voi ch'intrate"};
    }

    @Callback
    public Object[] setPassword(Context context, Arguments args) {
        if (this.password.isEmpty()) {
            this.password = args.checkString(0);
            return new Object[]{"Password set"};
        }
        if (args.checkString(0).equals(this.password)) {
            this.password = args.checkString(1);
            return new Object[]{"Password Changed"};
        }
        return new Object[]{"Password was not changed"};
    }

    @Callback
    public Object[] setSide(Context context, Arguments args) throws Exception {
        int side = args.checkInteger(0);
        Boolean isEnabled = args.checkBoolean(1);
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ForgeDirection facing = TileEntitySwitchableHub.getWorldSide(ForgeDirection.getOrientation((int)side).name(), ForgeDirection.getOrientation((int)meta));
        if (!this.password.isEmpty() && !this.password.equals(args.checkString(2))) {
            return new Object[]{"Password Incorrect"};
        }
        switch (facing) {
            case NORTH: {
                this.north = isEnabled;
                break;
            }
            case SOUTH: {
                this.south = isEnabled;
                break;
            }
            case EAST: {
                this.east = isEnabled;
                break;
            }
            case WEST: {
                this.west = isEnabled;
                break;
            }
            case UP: {
                this.up = isEnabled;
                break;
            }
            case DOWN: {
                this.down = isEnabled;
                break;
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145844_m();
        if (this.node != null) {
            this.node.remove();
        }
        if (this.node != null && this.node.network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
        if (((Connector)this.node).changeBuffer(-5.0) == 0.0) {
            return new Object[]{"ok"};
        }
        throw new Exception("Not enough power in OC Network.");
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCom = new NBTTagCompound();
        this.func_145841_b(tagCom);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tagCom);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCom = packet.func_148857_g();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145839_a(tagCom);
    }

    public static ForgeDirection getWorldSide(String localSide, ForgeDirection facing) {
        if ("up".equalsIgnoreCase(localSide)) {
            return ForgeDirection.UP;
        }
        if ("down".equalsIgnoreCase(localSide)) {
            return ForgeDirection.DOWN;
        }
        ForgeDirection front = facing;
        switch (front) {
            case NORTH: {
                sideBack = ForgeDirection.SOUTH;
                sideLeft = ForgeDirection.WEST;
                sideRight = ForgeDirection.EAST;
                break;
            }
            case SOUTH: {
                sideBack = ForgeDirection.NORTH;
                sideLeft = ForgeDirection.EAST;
                sideRight = ForgeDirection.WEST;
                break;
            }
            case WEST: {
                sideBack = ForgeDirection.EAST;
                sideLeft = ForgeDirection.SOUTH;
                sideRight = ForgeDirection.NORTH;
                break;
            }
            case EAST: {
                sideBack = ForgeDirection.WEST;
                sideLeft = ForgeDirection.NORTH;
                sideRight = ForgeDirection.SOUTH;
                break;
            }
            case UP: {
                sideBack = ForgeDirection.NORTH;
                sideLeft = ForgeDirection.EAST;
                sideRight = ForgeDirection.WEST;
                sideFront = ForgeDirection.SOUTH;
                break;
            }
            case DOWN: {
                sideBack = ForgeDirection.NORTH;
                sideLeft = ForgeDirection.EAST;
                sideRight = ForgeDirection.WEST;
                sideFront = ForgeDirection.SOUTH;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid side");
            }
        }
        if ("south".equalsIgnoreCase(localSide)) {
            return sideFront;
        }
        if ("north".equalsIgnoreCase(localSide)) {
            return sideBack;
        }
        if ("east".equalsIgnoreCase(localSide)) {
            return sideLeft;
        }
        if ("west".equalsIgnoreCase(localSide)) {
            return sideRight;
        }
        throw new IllegalArgumentException("Invalid side");
    }
}

