/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.personalspace.block;

import cpw.mods.fml.common.eventhandler.Event;
import me.eigenraven.personalspace.Config;
import me.eigenraven.personalspace.PersonalSpaceMod;
import me.eigenraven.personalspace.block.PortalBlock;
import me.eigenraven.personalspace.net.Packets;
import me.eigenraven.personalspace.world.DimensionConfig;
import me.eigenraven.personalspace.world.PersonalTeleporter;
import me.eigenraven.personalspace.world.PersonalWorldProvider;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;

public class PortalTileEntity
extends TileEntity {
    public static final ForgeDirection DEFAULT_FACING = ForgeDirection.NORTH;
    public boolean active = false;
    public int targetDimId = 0;
    public int targetPosX = 8;
    public int targetPosY = 8;
    public int targetPosZ = 8;
    public ForgeDirection targetFacing = DEFAULT_FACING;
    public ForgeDirection facing = DEFAULT_FACING;

    public void func_145839_a(NBTTagCompound tag) {
        if (tag.func_74764_b("x") || tag.func_74764_b("y") || tag.func_74764_b("z")) {
            super.func_145839_a(tag);
        }
        boolean isLegacy = false;
        if (tag.func_74764_b("isReturnPortal")) {
            isLegacy = true;
            if (tag.func_74767_n("isReturnPortal")) {
                this.targetDimId = 0;
            }
        }
        if (tag.func_74764_b("remoteDimensionId")) {
            isLegacy = true;
            this.targetDimId = tag.func_74762_e("remoteDimensionId");
        }
        if (tag.func_74764_b("remotePos")) {
            isLegacy = true;
            int[] pos_array = tag.func_74759_k("remotePos");
            this.targetPosX = pos_array[0];
            this.targetPosY = pos_array[1];
            this.targetPosZ = pos_array[2];
        }
        if (tag.func_74764_b("remoteDir")) {
            isLegacy = true;
            byte remoteDir = tag.func_74771_c("remoteDir");
            switch (remoteDir) {
                case 0: {
                    ForgeDirection forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                case 1: {
                    ForgeDirection forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case 3: {
                    ForgeDirection forgeDirection = ForgeDirection.WEST;
                    break;
                }
                default: {
                    ForgeDirection forgeDirection = this.facing = ForgeDirection.SOUTH;
                }
            }
        }
        if (tag.func_74764_b("localDimensionId")) {
            isLegacy = true;
        }
        if (tag.func_74764_b("localDir")) {
            isLegacy = true;
        }
        if (tag.func_74764_b("active")) {
            this.active = tag.func_74767_n("active");
        }
        if (tag.func_74764_b("target")) {
            int[] t_array = tag.func_74759_k("target");
            this.targetDimId = t_array[0];
            this.targetPosX = t_array[1];
            this.targetPosY = t_array[2];
            this.targetPosZ = t_array[3];
        }
        if (tag.func_74764_b("facing")) {
            this.facing = ForgeDirection.getOrientation((int)tag.func_74762_e("facing"));
        }
        if (tag.func_74764_b("targetFacing")) {
            this.targetFacing = ForgeDirection.getOrientation((int)tag.func_74762_e("targetFacing"));
        }
        if (isLegacy) {
            this.active = true;
            PersonalSpaceMod.LOG.info("Migrated old UW portal to dim {} : target {},{},{}", new Object[]{this.targetDimId, this.targetPosX, this.targetPosY, this.targetPosZ});
            this.func_70296_d();
        }
        if (this.facing == ForgeDirection.UNKNOWN) {
            this.facing = ForgeDirection.NORTH;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("active", this.active);
        tag.func_74783_a("target", new int[]{this.targetDimId, this.targetPosX, this.targetPosY, this.targetPosZ});
        tag.func_74768_a("facing", this.facing.ordinal());
        tag.func_74768_a("targetFacing", this.targetFacing.ordinal());
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (this.field_145850_b.field_72995_K) {
            this.func_145839_a(pkt.func_148857_g());
            PersonalSpaceMod.proxy.closePortalGui(this);
        }
    }

    public void transport(EntityPlayerMP player) {
        if (this.field_145850_b.field_72995_K || !this.active || player == null) {
            return;
        }
        if (!DimensionManager.isDimensionRegistered((int)this.targetDimId)) {
            PersonalSpaceMod.LOG.warn("Player {} attempted to teleport to dimension {} which is not registered yet", new Object[]{player.func_146103_bH(), this.targetDimId});
            return;
        }
        PersonalTeleporter tp = new PersonalTeleporter(this, (WorldServer)this.field_145850_b);
        player.field_71133_b.func_71203_ab().transferPlayerToDimension(player, this.targetDimId, (Teleporter)tp);
    }

    public int getTargetTeleportX() {
        return this.targetPosX + this.targetFacing.offsetX;
    }

    public int getTargetTeleportY() {
        return this.targetPosY + this.targetFacing.offsetY;
    }

    public int getTargetTeleportZ() {
        return this.targetPosZ + this.targetFacing.offsetZ;
    }

    public void linkOtherPortal(boolean spawnNewPortal, EntityPlayerMP player) {
        if (!this.active) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        WorldServer otherWorld = DimensionManager.getWorld((int)this.targetDimId);
        if (otherWorld == null) {
            DimensionManager.initDimension((int)this.targetDimId);
            otherWorld = DimensionManager.getWorld((int)this.targetDimId);
        }
        if (otherWorld == null) {
            PersonalSpaceMod.LOG.fatal("Couldn't initialize world {}", new Object[]{this.targetDimId});
            return;
        }
        int otherX = this.targetPosX;
        int otherY = this.targetPosY;
        int otherZ = this.targetPosZ;
        block0: for (otherX = this.targetPosX - 1; otherX <= this.targetPosX + 1; ++otherX) {
            for (otherY = this.targetPosY - 1; otherY <= this.targetPosY + 1; ++otherY) {
                if (otherY < 0 || otherY > otherWorld.func_72800_K()) continue;
                for (otherZ = this.targetPosZ - 1; otherZ <= this.targetPosZ + 1; ++otherZ) {
                    if (!otherWorld.func_72899_e(otherX, otherY, otherZ)) {
                        otherWorld.field_73059_b.func_73158_c(otherX >> 4, otherZ >> 4);
                    }
                    if (otherWorld.func_147439_a(otherX, otherY, otherZ) instanceof PortalBlock) break block0;
                }
            }
        }
        PortalTileEntity otherPortal = null;
        if (otherWorld.func_147439_a(otherX, otherY, otherZ) == PersonalSpaceMod.BLOCK_PORTAL) {
            TileEntity wte = otherWorld.func_147438_o(otherX, otherY, otherZ);
            if (wte instanceof PortalTileEntity) {
                otherPortal = (PortalTileEntity)wte;
            }
        } else if (spawnNewPortal) {
            otherX = this.targetPosX;
            otherY = this.targetPosY;
            otherZ = this.targetPosZ;
            otherWorld.func_147465_d(otherX, otherY, otherZ, (Block)PersonalSpaceMod.BLOCK_PORTAL, this.facing.ordinal(), 3);
            otherPortal = (PortalTileEntity)otherWorld.func_147438_o(otherX, otherY, otherZ);
        }
        if (otherPortal != null) {
            otherPortal.active = true;
            DimensionConfig otherPortalDimCfg = DimensionConfig.getForDimension(otherPortal.targetDimId, false);
            if (otherPortal.targetDimId != this.field_145850_b.field_73011_w.field_76574_g && otherPortalDimCfg != null) {
                if (player != null) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.personalWorld.relinked.error", new Object[0]));
                }
                return;
            }
            otherPortal.targetDimId = this.field_145850_b.field_73011_w.field_76574_g;
            otherPortal.targetPosX = this.field_145851_c;
            otherPortal.targetPosY = this.field_145848_d;
            otherPortal.targetPosZ = this.field_145849_e;
            otherPortal.targetFacing = this.facing;
            otherPortal.func_70296_d();
            if (player != null) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.personalWorld.relinked", new Object[]{this.targetDimId}));
            }
            PersonalSpaceMod.LOG.info("Linked portal at {}:{},{},{} to {}:{},{},{}", new Object[]{this.targetDimId, otherX, otherY, otherZ, this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e});
        }
    }

    public void updateSettings(EntityPlayerMP player, DimensionConfig unsafeConfig) {
        BlockEvent.BreakEvent fakeBreakEvent;
        if (this.field_145850_b.field_72995_K || player == null) {
            return;
        }
        if (!this.field_145850_b.func_72962_a((EntityPlayer)player, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.personalWorld.denied", new Object[0]));
            PersonalSpaceMod.LOG.warn("Player {} tried to modify settings for portal block @{},{},{} (dim {}, target dim {}), denied - spawn protection.", new Object[]{player, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g, this.targetDimId});
            return;
        }
        if (Config.useBlockEventChecks && MinecraftForge.EVENT_BUS.post((Event)(fakeBreakEvent = new BlockEvent.BreakEvent(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b, (Block)PersonalSpaceMod.BLOCK_PORTAL, 0, (EntityPlayer)player)))) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.personalWorld.denied", new Object[0]));
            PersonalSpaceMod.LOG.warn("Player {} tried to modify settings for portal block @{},{},{} (dim {}, target dim {}), denied - block permission.", new Object[]{player, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g, this.targetDimId});
            return;
        }
        if (!DimensionConfig.canUseLayers(unsafeConfig.getLayersAsString(), false)) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.personalWorld.badLayers", new Object[0]));
            PersonalSpaceMod.LOG.warn("Player {} tried to modify settings for portal block @{},{},{} (dim {}, target dim {}), denied - using forbidden layers.", new Object[]{player, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g, this.targetDimId});
            return;
        }
        if (!DimensionConfig.canUseBiome(unsafeConfig.getBiomeId(), false)) {
            unsafeConfig.setBiomeId("Plains");
        }
        DimensionConfig sanitized = new DimensionConfig();
        sanitized.copyFrom(unsafeConfig, false, true, true);
        boolean createdNewDim = false;
        int targetDimId = 0;
        if (this.field_145850_b.field_73011_w instanceof PersonalWorldProvider) {
            targetDimId = this.field_145850_b.field_73011_w.field_76574_g;
        } else if (this.active) {
            targetDimId = this.targetDimId;
        }
        boolean changed = true;
        if (targetDimId > 0) {
            DimensionConfig realConfig = DimensionConfig.getForDimension(targetDimId, false);
            if (realConfig == null) {
                return;
            }
            changed = realConfig.copyFrom(sanitized, false, true, realConfig.getAllowGenerationChanges());
            realConfig.setAllowGenerationChanges(false);
            PersonalSpaceMod.INSTANCE.onDimSettingsChangeServer(targetDimId);
        } else {
            if (this.field_145850_b.field_73011_w.field_76574_g != 0) {
                return;
            }
            targetDimId = DimensionConfig.nextFreeDimId();
            sanitized.setAllowGenerationChanges(false);
            sanitized.registerWithDimensionManager(targetDimId, false);
            PersonalSpaceMod.INSTANCE.onDimSettingsChangeServer(targetDimId);
            this.active = true;
            this.targetDimId = targetDimId;
            this.targetPosY = sanitized.getGroundLevel() + 1;
            this.func_70296_d();
            createdNewDim = true;
            this.linkOtherPortal(true, player);
        }
        Packets.INSTANCE.sendWorldList().sendToClients();
        if (createdNewDim) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.personalWorld.created", new Object[0]));
        } else if (changed) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.personalWorld.updated", new Object[0]));
        }
    }
}

