/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.gtnewhorizon.structurelib.ConfigurationVersion;
import com.gtnewhorizon.structurelib.RegistryOrderEntry;
import com.gtnewhorizon.structurelib.SortedRegistry;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.tuple.Pair;

public enum ConfigurationHandler {
    INSTANCE;

    private Configuration config;
    private int maxCoexistingHologram;
    private boolean removeCollidingHologram;
    private int hintLifespan;
    private int hintTransparency;
    private int autoPlaceBudget;
    private int autoPlaceInterval;
    private Map<String, Pair<List<String>, List<String>>> registryOrders;

    private ConfigurationHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    void init(File f) {
        this.config = new Configuration(f, ConfigurationVersion.latest().getVersionMarker());
        ConfigurationVersion.migrateToLatest(this.config);
        this.loadConfig();
        this.setLanguageKeys();
    }

    private void setLanguageKeys() {
        for (String categoryName : this.config.getCategoryNames()) {
            ConfigCategory category = this.config.getCategory(categoryName);
            category.setLanguageKey("structurelib.config." + categoryName);
            for (Map.Entry entry : category.entrySet()) {
                ((Property)entry.getValue()).setLanguageKey(String.format("%s.%s", category.getLanguagekey(), entry.getKey()));
            }
        }
    }

    private void loadConfig() {
        this.maxCoexistingHologram = this.config.getInt("maxCoexisting", "client.hologram", 1, 1, 100, "An attempt will be made to prune old holograms when a new hologram is about to be projected");
        this.removeCollidingHologram = this.config.getBoolean("removeColliding", "client.hologram", true, "An attempt will be made to remove an existing hologram if it collides with a new hologram.");
        this.hintLifespan = this.config.getInt("hintLifespan", "client.hologram", 400, 1, 20000, "Ticks before a hologram disappears.");
        this.hintTransparency = this.config.getInt("hintTransparency", "client.hologram", 192, 1, 255, "Alpha value of hologram particles. Higher the value, the more \"ghostly\" the hologram will appear to be.");
        this.autoPlaceBudget = this.config.getInt("autoPlaceBudget", "common.hologram", 25, 1, 200, "Max number of elements can be placed in one round of auto place.\nAs expected, server side settings will overrides client settings.\nCertain larger multi might increase these values beyond this configured value.");
        this.autoPlaceInterval = this.config.getInt("autoPlaceInterval", "common.hologram", 300, 0, 20000, "Unit: millisecond. Minimal interval between two auto place round.\nAs expected, server side settings will overrides client settings.\nNote this relates to the wall clock, not in game ticks.\nValue smaller than default is likely to be perceived as no minimal interval whatsoever.");
        this.loadRegistryOrder();
        this.saveConfig();
    }

    void loadRegistryOrder() {
        this.loadRegistryOrderImpl();
        this.setLanguageKeys();
        this.saveConfig();
    }

    private void loadRegistryOrderImpl() {
        this.registryOrders = new HashMap<String, Pair<List<String>, List<String>>>();
        for (Map.Entry<String, WeakReference<SortedRegistry<?>>> e : SortedRegistry.ALL_REGISTRIES.entrySet()) {
            SortedRegistry r = (SortedRegistry)e.getValue().get();
            if (r == null) continue;
            String category = "registries." + e.getKey();
            if (FMLLaunchHandler.side().isClient()) {
                this.config.setCategoryConfigEntryClass(category, RegistryOrderEntry.class);
            }
            Property pOrder = this.config.get(category, "ordering", (String[])Iterables.toArray(r.getCurrentOrdering(), String.class), "stuff not in this list will be automatically available after all entries listed here in their natural order, unless explicitly disabled in disabled config below.");
            Property pDisable = this.config.get(category, "disabled", new String[0], "stuff in this list will be disabled");
            ArrayList all = Lists.newArrayList(r.getCurrentOrdering());
            ArrayList<String> curVal = new ArrayList<String>(Arrays.asList(pOrder.getStringList()));
            ArrayList<String> disabled = new ArrayList<String>(Arrays.asList(pDisable.getStringList()));
            curVal.removeAll(disabled);
            all.removeAll(disabled);
            curVal.removeIf(s -> !all.remove(s));
            curVal.addAll(all);
            pOrder.set(curVal.toArray(new String[0]));
            this.registryOrders.put(e.getKey(), (Pair<List<String>, List<String>>)Pair.of(curVal, disabled));
        }
        this.saveConfig();
    }

    private void saveConfig() {
        if (this.config.hasChanged()) {
            this.config.save();
            this.config.load();
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.PostConfigChangedEvent e) {
        if (e.modID.equals("structurelib")) {
            this.loadConfig();
        }
    }

    public int getMaxCoexistingHologram() {
        return this.maxCoexistingHologram;
    }

    public boolean isRemoveCollidingHologram() {
        return this.removeCollidingHologram;
    }

    public int getHintLifespan() {
        return this.hintLifespan;
    }

    public int getHintTransparency() {
        return this.hintTransparency;
    }

    public int getAutoPlaceBudget() {
        return this.autoPlaceBudget;
    }

    public int getAutoPlaceInterval() {
        return this.autoPlaceInterval;
    }

    public Pair<List<String>, List<String>> getRegistryOrder(String name) {
        return this.registryOrders.get(name);
    }

    Configuration getConfig() {
        return this.config;
    }
}

