/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.alignment.constructable;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.util.MiscUtils;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ChannelDataAccessor {
    private static final String SECONDARY_HINT_TAG = "channels";

    private ChannelDataAccessor() {
    }

    public static ItemStack withChannel(ItemStack masterStack, String channel) {
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack == null) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        if (!(masterStack.func_77942_o() && masterStack.field_77990_d.func_150297_b(SECONDARY_HINT_TAG, 10) && masterStack.field_77990_d.func_74775_l(SECONDARY_HINT_TAG).func_150297_b(channel, 3))) {
            return masterStack;
        }
        ItemStack ret = new ItemStack(masterStack.func_77973_b(), masterStack.field_77990_d.func_74775_l(SECONDARY_HINT_TAG).func_74762_e(channel), Items.field_151008_G.getDamage(masterStack));
        ret.func_77982_d(masterStack.field_77990_d);
        return ret;
    }

    public static boolean hasSubChannel(ItemStack masterStack) {
        if (masterStack == null) {
            throw new IllegalArgumentException();
        }
        return masterStack.func_77942_o() && masterStack.field_77990_d.func_150297_b(SECONDARY_HINT_TAG, 10);
    }

    public static boolean hasSubChannel(ItemStack masterStack, String channel) {
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack == null) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        return !channel.isEmpty() && masterStack.func_77942_o() && masterStack.field_77990_d.func_150297_b(SECONDARY_HINT_TAG, 10) && masterStack.field_77990_d.func_74775_l(SECONDARY_HINT_TAG).func_150297_b(channel, 3);
    }

    public static int getChannelData(ItemStack masterStack, String channel) {
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack == null) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        if (!(masterStack.func_77942_o() && masterStack.field_77990_d.func_150297_b(SECONDARY_HINT_TAG, 10) && masterStack.field_77990_d.func_74775_l(SECONDARY_HINT_TAG).func_150297_b(channel, 3))) {
            return masterStack.field_77994_a;
        }
        return masterStack.field_77990_d.func_74775_l(SECONDARY_HINT_TAG).func_74762_e(channel);
    }

    public static void setChannelData(ItemStack masterStack, String channel, int data) {
        NBTTagCompound main;
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack == null) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        if (data <= 0) {
            throw new IllegalArgumentException();
        }
        if (masterStack.field_77990_d == null) {
            masterStack.field_77990_d = new NBTTagCompound();
        }
        if (!(main = masterStack.field_77990_d).func_150297_b(SECONDARY_HINT_TAG, 10)) {
            main.func_74782_a(SECONDARY_HINT_TAG, (NBTBase)new NBTTagCompound());
        }
        main.func_74775_l(SECONDARY_HINT_TAG).func_74768_a(channel, data);
    }

    public static void unsetChannelData(ItemStack masterStack, String channel) {
        NBTTagCompound main;
        if (StringUtils.isEmpty((CharSequence)channel) || masterStack == null) {
            throw new IllegalArgumentException();
        }
        if (StructureLibAPI.isDebugEnabled() && !channel.toLowerCase(Locale.ROOT).equals(channel)) {
            throw new IllegalArgumentException("Channel name can be lower case ONLY");
        }
        if (masterStack.field_77990_d == null) {
            masterStack.field_77990_d = new NBTTagCompound();
        }
        if (!(main = masterStack.field_77990_d).func_150297_b(SECONDARY_HINT_TAG, 10)) {
            main.func_74782_a(SECONDARY_HINT_TAG, (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound tag = main.func_74775_l(SECONDARY_HINT_TAG);
        tag.func_82580_o(channel);
        if (tag.func_82582_d()) {
            main.func_82580_o(SECONDARY_HINT_TAG);
        }
        if (main.func_82582_d()) {
            masterStack.field_77990_d = null;
        }
    }

    public static void wipeChannelData(ItemStack masterStack) {
        if (masterStack == null) {
            throw new IllegalArgumentException();
        }
        if (masterStack.field_77990_d != null) {
            masterStack.field_77990_d.func_82580_o(SECONDARY_HINT_TAG);
        }
    }

    public static Stream<Map.Entry<String, Integer>> iterateChannelData(ItemStack masterStack) {
        if (!ChannelDataAccessor.hasSubChannel(masterStack)) {
            return Stream.empty();
        }
        NBTTagCompound tag = masterStack.field_77990_d.func_74775_l(SECONDARY_HINT_TAG);
        return MiscUtils.getTagKeys(tag).stream().map(s -> new ImmutablePair(s, (Object)tag.func_74762_e(s)));
    }

    public static int countChannelData(ItemStack masterStack) {
        if (!ChannelDataAccessor.hasSubChannel(masterStack)) {
            return 0;
        }
        NBTTagCompound tag = masterStack.field_77990_d.func_74775_l(SECONDARY_HINT_TAG);
        return tag.func_150296_c().size();
    }
}

