/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.structure;

import com.gtnewhorizon.structurelib.util.InventoryIterable;
import com.gtnewhorizon.structurelib.util.InventoryUtility;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public interface IItemSource {
    @Nonnull
    public Map<ItemStack, Integer> take(Predicate<ItemStack> var1, boolean var2, int var3);

    default public ItemStack takeOne(Predicate<ItemStack> predicate, boolean simulate) {
        if (predicate == null) {
            throw new IllegalArgumentException();
        }
        Map<ItemStack, Integer> take = this.take(predicate, simulate, 1);
        return take.isEmpty() ? null : take.keySet().iterator().next();
    }

    default public boolean takeAll(Predicate<ItemStack> predicate, boolean simulate, int count) {
        if (count == 1) {
            return this.takeOne(predicate, simulate) != null;
        }
        Map<ItemStack, Integer> have = this.take(predicate, true, count);
        if (have.values().stream().mapToInt(Integer::intValue).sum() < count) {
            return false;
        }
        this.take(predicate, simulate, count);
        return true;
    }

    default public boolean takeOne(ItemStack stack, boolean simulate) {
        if (stack == null || stack.func_77973_b() == null || stack.field_77994_a != 1) {
            throw new IllegalArgumentException();
        }
        ItemStack took = this.takeOne(ItemStackPredicate.from(stack, ItemStackPredicate.NBTMode.EXACT), simulate);
        return took != null && took.field_77994_a > 0;
    }

    default public boolean takeAll(ItemStack stack, boolean simulate) {
        if (stack == null || stack.func_77973_b() == null) {
            throw new IllegalArgumentException();
        }
        if (stack.field_77994_a == 1) {
            return this.takeOne(stack, simulate);
        }
        ItemStackPredicate predicate = ItemStackPredicate.from(stack, ItemStackPredicate.NBTMode.EXACT);
        Map<ItemStack, Integer> have = this.take(predicate, true, stack.field_77994_a);
        if (have.values().stream().mapToInt(Integer::intValue).sum() < stack.field_77994_a) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.take(predicate, false, stack.field_77994_a);
        return true;
    }

    public static IItemSource fromPlayer(final EntityPlayerMP player) {
        return new IItemSource(){

            @Override
            @Nonnull
            public Map<ItemStack, Integer> take(Predicate<ItemStack> p, boolean s, int c) {
                return InventoryUtility.takeFromInventory(player, p, s, c);
            }

            @Override
            public boolean takeOne(ItemStack stack, boolean simulate) {
                if (stack == null || stack.func_77973_b() == null || stack.field_77994_a != 1) {
                    throw new IllegalArgumentException();
                }
                return InventoryUtility.takeFromInventory(player, stack, simulate) == 1;
            }

            @Override
            public boolean takeAll(ItemStack stack, boolean simulate) {
                return InventoryUtility.takeFromInventory(player, stack, simulate) == stack.field_77994_a;
            }
        };
    }

    public static IItemSource fromInventory(IInventory inv) {
        return (p, s, c) -> InventoryUtility.takeFromInventory(new InventoryIterable<IInventory>(inv), p, s, c, true);
    }
}

