/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.cachebuilder;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.ServerCache;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import it.unimi.dsi.fastutil.shorts.Short2IntMap;
import it.unimi.dsi.fastutil.shorts.Short2IntOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class DetailedChunkAnalysis {
    private final int dimensionId;
    public final int chunkX;
    public final int chunkZ;
    private final Short2IntMap[] oresPerY = new Short2IntOpenHashMap[256];
    private final String dimName;

    public DetailedChunkAnalysis(int dimensionId, String dimName, int chunkX, int chunkZ) {
        this.dimensionId = dimensionId;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.dimName = dimName;
    }

    public void processMinecraftChunk(NBTTagList tileEntities) {
        if (tileEntities == null || tileEntities.func_74745_c() == 0) {
            return;
        }
        for (int i = 0; i < tileEntities.func_74745_c(); ++i) {
            short meta;
            String id;
            NBTTagCompound tile = tileEntities.func_150305_b(i);
            if (tile == null || !tile.func_74764_b("m") || !"GT_TileEntity_Ores".equals(id = tile.func_74779_i("id")) && !"bw.blockoresTE".equals(id) || Utils.isSmallOreId(meta = tile.func_74765_d("m")) || meta == 0) continue;
            meta = Utils.oreIdToMaterialId(meta);
            int blockY = tile.func_74762_e("y");
            if (this.oresPerY[blockY] == null) {
                this.oresPerY[blockY] = new Short2IntOpenHashMap();
            }
            this.oresPerY[blockY].put(meta, this.oresPerY[blockY].get(meta) + 1);
        }
    }

    public void cleanUpWithNeighbors(Map<Long, Integer> veinChunkY) {
        OreVeinPosition[] neighbors = new OreVeinPosition[]{ServerCache.instance.getOreVein(this.dimensionId, this.chunkX - 3, this.chunkZ + 3), ServerCache.instance.getOreVein(this.dimensionId, this.chunkX, this.chunkZ + 3), ServerCache.instance.getOreVein(this.dimensionId, this.chunkX + 3, this.chunkZ + 3), ServerCache.instance.getOreVein(this.dimensionId, this.chunkX + 3, this.chunkZ), ServerCache.instance.getOreVein(this.dimensionId, this.chunkX + 3, this.chunkZ - 3), ServerCache.instance.getOreVein(this.dimensionId, this.chunkX, this.chunkZ - 3), ServerCache.instance.getOreVein(this.dimensionId, this.chunkX - 3, this.chunkZ - 3), ServerCache.instance.getOreVein(this.dimensionId, this.chunkX - 3, this.chunkZ)};
        int[] neighborVeinBlockY = new int[]{veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX - 3), Utils.mapToCenterOreChunkCoord(this.chunkZ + 3)), 0), veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX), Utils.mapToCenterOreChunkCoord(this.chunkZ + 3)), 0), veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX + 3), Utils.mapToCenterOreChunkCoord(this.chunkZ + 3)), 0), veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX + 3), Utils.mapToCenterOreChunkCoord(this.chunkZ)), 0), veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX + 3), Utils.mapToCenterOreChunkCoord(this.chunkZ - 3)), 0), veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX), Utils.mapToCenterOreChunkCoord(this.chunkZ - 3)), 0), veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX - 3), Utils.mapToCenterOreChunkCoord(this.chunkZ - 3)), 0), veinChunkY.getOrDefault(Utils.chunkCoordsToKey(Utils.mapToCenterOreChunkCoord(this.chunkX - 3), Utils.mapToCenterOreChunkCoord(this.chunkZ)), 0)};
        for (int neighborId = 0; neighborId < neighbors.length; ++neighborId) {
            int blockY;
            boolean canOverlap;
            OreVeinPosition neighbor = neighbors[neighborId];
            if (neighbor.veinType == VeinType.NO_VEIN) continue;
            boolean atCoordinateAxis = Math.abs(neighbor.chunkX - this.chunkX) < 3 || Math.abs(neighbor.chunkZ - this.chunkZ) < 3;
            boolean bl = canOverlap = atCoordinateAxis ? neighbor.veinType.canOverlapIntoNeighborOreChunkAtCoordinateAxis() : neighbor.veinType.canOverlapIntoNeighborOreChunk();
            if (!canOverlap) continue;
            int veinBlockY = neighborVeinBlockY[neighborId];
            for (int layerBlockY = 0; layerBlockY < 9 && (blockY = veinBlockY + layerBlockY) <= 255; ++layerBlockY) {
                if (this.oresPerY[blockY] == null) continue;
                ShortIterator shortIterator = neighbor.veinType.getOresAtLayer(layerBlockY).iterator();
                while (shortIterator.hasNext()) {
                    short metaData = (Short)shortIterator.next();
                    this.oresPerY[blockY].remove(metaData);
                }
            }
        }
    }

    public VeinType getMatchedVein() {
        HashSet<VeinType> matchedVeins = new HashSet<VeinType>();
        Short2IntOpenHashMap allOres = new Short2IntOpenHashMap();
        for (Short2IntMap oreLevel : this.oresPerY) {
            if (oreLevel == null || oreLevel.isEmpty()) continue;
            for (Short2IntMap.Entry entry : oreLevel.short2IntEntrySet()) {
                short metaData = entry.getShortKey();
                int numberOfBlocks = entry.getIntValue();
                allOres.merge(metaData, numberOfBlocks, Integer::sum);
            }
        }
        if (allOres.isEmpty()) {
            return VeinType.NO_VEIN;
        }
        Optional<Short> dominantOre = allOres.short2IntEntrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).map(Map.Entry::getKey).findFirst();
        if (!dominantOre.isPresent()) {
            return VeinType.NO_VEIN;
        }
        for (VeinType veinType2 : VeinTypeCaching.getVeinTypes()) {
            if (!veinType2.matchesWithSpecificPrimaryOrSecondary((ShortCollection)allOres.keySet(), this.dimName, dominantOre.get())) continue;
            matchedVeins.add(veinType2);
        }
        if (matchedVeins.size() == 1) {
            return (VeinType)matchedVeins.iterator().next();
        }
        if (matchedVeins.size() >= 2) {
            matchedVeins.removeIf(veinType -> IntStream.range(veinType.minBlockY, veinType.maxBlockY).noneMatch(blockY -> this.isOreVeinGeneratedAtHeight((VeinType)veinType, blockY)));
            if (matchedVeins.size() == 1) {
                return (VeinType)matchedVeins.iterator().next();
            }
        }
        return VeinType.NO_VEIN;
    }

    private boolean isOreVeinGeneratedAtHeight(VeinType veinType, int blockY) {
        for (int layer = 0; layer < 9; ++layer) {
            if (this.oresPerY[blockY + layer] != null && this.oresPerY[blockY + layer].keySet().containsAll((ShortCollection)veinType.getOresAtLayer(layer))) continue;
            return false;
        }
        return true;
    }
}

