/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.render;

import com.gtnewhorizons.navigator.api.model.locations.ILocationProvider;
import com.gtnewhorizons.navigator.api.model.steps.UniversalRenderStep;
import com.gtnewhorizons.navigator.api.util.DrawUtils;
import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.integration.model.layers.UndergroundFluidLayerManager;
import com.sinthoras.visualprospecting.integration.model.locations.UndergroundFluidLocation;
import net.minecraft.client.resources.I18n;

public class UndergroundFluidRenderStep
extends UniversalRenderStep<UndergroundFluidLocation> {
    public UndergroundFluidRenderStep(UndergroundFluidLocation location) {
        super((ILocationProvider)location);
        this.setSize(128.0);
        this.setFontScale(0.5);
    }

    public void draw(double topX, double topY, float drawScale, double zoom) {
        this.renderChunks(topX, topY);
        this.setSize(128.0);
        int alpha = ((UndergroundFluidLocation)this.location).isActive() ? 255 : 74;
        DrawUtils.drawHollowRect((double)topX, (double)topY, (double)this.getAdjustedWidth(), (double)(this.getAdjustedHeight() - 0.5), (int)((UndergroundFluidLocation)this.location).getFluid().getColor(), (int)alpha, (double)2.0);
        if (!this.isMinimap()) {
            int maxAmountInField = ((UndergroundFluidLocation)this.location).getMaxProduction();
            String label = I18n.func_135052_a((String)"visualprospecting.empty", (Object[])new Object[0]);
            if (maxAmountInField > 0) {
                label = ((UndergroundFluidLocation)this.location).getMinProduction() + "L - " + maxAmountInField + "L  " + ((UndergroundFluidLocation)this.location).getFluid().getLocalizedName();
            }
            int textColor = -1;
            if (UndergroundFluidLayerManager.instance.isSearchActive()) {
                textColor = ((UndergroundFluidLocation)this.location).isActive() ? 0xFFFF00 : 0x444444;
            }
            DrawUtils.drawLabel((String)label, (double)(topX + this.getAdjustedWidth() / 2.0), (double)(topY + 1.5), (int)textColor, (int)-1275068416, (boolean)true, (double)this.getFontScale());
        }
    }

    private void renderChunks(double x, double y) {
        if (this.getZoomStep() < (double)Config.minZoomLevelForUndergroundFluidDetails || ((UndergroundFluidLocation)this.location).getMaxProduction() <= 0 || !((UndergroundFluidLocation)this.location).isActive()) {
            return;
        }
        this.setSize(16.0);
        for (int chunkX = 0; chunkX < 8; ++chunkX) {
            for (int chunkZ = 0; chunkZ < 8; ++chunkZ) {
                double xOffset = (double)chunkX * this.getAdjustedWidth();
                double yOffset = (double)chunkZ * this.getAdjustedHeight();
                int amount = ((UndergroundFluidLocation)this.location).getChunks()[chunkX][chunkZ];
                if (amount <= 0) continue;
                float alpha = (float)(amount - ((UndergroundFluidLocation)this.location).getMinProduction()) / (float)(((UndergroundFluidLocation)this.location).getMaxProduction() - ((UndergroundFluidLocation)this.location).getMinProduction() + 1);
                int fluidColor = ((UndergroundFluidLocation)this.location).getFluid().getColor();
                DrawUtils.drawRect((double)(x + xOffset), (double)(y + yOffset), (double)this.getAdjustedWidth(), (double)this.getAdjustedHeight(), (int)fluidColor, (int)((int)(alpha *= 255.0f)));
                if (amount >= ((UndergroundFluidLocation)this.location).getMaxProduction()) {
                    DrawUtils.drawHollowRect((double)(x + xOffset), (double)(y + yOffset), (double)this.getAdjustedWidth(), (double)this.getAdjustedHeight(), (int)16766720, (int)204, (double)1.5);
                }
                DrawUtils.drawLabel((String)this.getFluidAmountFormatted(amount), (double)(x + xOffset + this.getAdjustedWidth() / 2.0), (double)(y + yOffset + this.getAdjustedHeight() / 2.0), (int)-1, (int)-1275068416, (boolean)true, (double)this.getFontScale());
            }
        }
    }

    private String getFluidAmountFormatted(int amount) {
        if (amount >= 1000) {
            return amount / 1000 + "kL";
        }
        return amount + "L";
    }
}

